<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
require_once $_SERVER['DOCUMENT_ROOT'] . '/PHPMailer-master/src/PHPMailer.php';
require_once $_SERVER['DOCUMENT_ROOT'] . '/PHPMailer-master/src/Exception.php';
require_once $_SERVER['DOCUMENT_ROOT'] . '/PHPMailer-master/src/SMTP.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

include($_SERVER['DOCUMENT_ROOT'] . '/db_config.php');

// Enable detailed error reporting
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Database connection with error handling
$conn = new mysqli($host, $username, $password, $dbname);
if ($conn->connect_error) {
    error_log("Database connection failed: " . $conn->connect_error);
    die("We're experiencing technical difficulties. Please try again later.");
}

$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);
    
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $message = "<div class='error-message'>Invalid email format.</div>";
    } else {
        $verificationCode = sprintf("%06d", mt_rand(100000, 999999));
        $_SESSION['verification_code'] = $verificationCode;
        $_SESSION['email'] = $email;
        
        // Debugging: Log the verification code
        error_log("Generated verification code: $verificationCode for $email");
        
        // Attempt to send email and handle the response
        $emailResult = sendVerificationEmail($email, $verificationCode);
        
        if ($emailResult === true) {
            header('Location: verify_code.php');
            exit;
        } else {
            // More detailed error message
            $errorDetails = $emailResult === false ? "Unknown error" : $emailResult;
            error_log("Email sending failed: $errorDetails");
            $message = "<div class='error-message'>Unable to send verification email. Error: $errorDetails</div>";
        }
    }
}

/**
 * Enhanced email sending function with detailed error reporting
 */
function sendVerificationEmail($toEmail, $verificationCode, $type = 'transfer') {
    $mail = new PHPMailer(true);
    try {
        // SMTP settings
        $mail->isSMTP();
        $mail->Host = 'server108.web-hosting.com';
        $mail->SMTPAuth = true;
        $mail->Username = 'admin@grownestcapital.com';
        $mail->Password = 'Omotoyosi8';
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port = 587;
        $mail->SMTPDebug = 2; // Enable verbose debug output
        $mail->Debugoutput = function($str, $level) {
            error_log("SMTP debug level $level: $str");
        };

        // Validate SMTP connection
        if (!$mail->smtpConnect()) {
            return "SMTP connection failed";
        }

        // MUST use the same domain as your SMTP credentials
        $mail->setFrom('admin@grownestcapital.com', 'Grownest Capital');
        $mail->addAddress($toEmail);
        $mail->addReplyTo('admin@grownestcapital.com', 'Support Team');
    
        // Email content
        $mail->isHTML(true);
        $mail->Subject = 'Password Reset Verification - Grownest Capital';
        
        // HTML Email Template
        $mail->Body = <<<HTML
<!DOCTYPE html>
<html>
<head>
    <style>
        body { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; background-color: #f5f5f9; margin: 0; padding: 0; color: #333; }
        .email-container { max-width: 600px; margin: 20px auto; background: white; border-radius: 10px; overflow: hidden; box-shadow: 0 0 20px rgba(0,0,0,0.1); }
        .header { background: #6366f1; color: white; padding: 30px; text-align: center; }
        .content { padding: 30px; }
        .code { background: #f3f4f6; padding: 15px; text-align: center; font-size: 24px; font-weight: bold; margin: 20px 0; border-radius: 5px; color: #6366f1; }
        .footer { background: #23232f; color: #a0a0a0; text-align: center; padding: 15px; font-size: 12px; }
    </style>
</head>
<body>
    <div class="email-container">
        <div class="header">
            <h1>Grownest Capital</h1>
            <p>Secure Crypto Management</p>
        </div>
        <div class="content">
            <h2>Password Reset Request</h2>
            <p>Hello,</p>
            <p>We received a request to reset your password. Please use this verification code:</p>
            <div class="code">$verificationCode</div>
            <p>This code expires in 15 minutes. If you didn't request this, please contact support immediately.</p>
        </div>
        <div class="footer">
            <p>&copy; 2024 Grownest Capital. All rights reserved.</p>
        </div>
    </div>
</body>
</html>
HTML;

        // Plain text fallback
        $mail->AltBody = "Grownest Capital Password Reset\n\nVerification Code: $verificationCode\n\nThis code expires in 15 minutes.";

        // Send the email
        if (!$mail->send()) {
            return "Mailer Error: " . $mail->ErrorInfo;
        }
        
        return true;
    } catch (Exception $e) {
        return "Exception: " . $e->getMessage();
    }
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Forgot Password - Grownest Capital</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --bg-primary: #1c1c28;
            --bg-secondary: #23232f;
            --text-primary: #ffffff;
            --text-secondary: #a0a0a0;
            --accent-color: #6366f1;
            --border-color: #32323f;
            --error-color: #ff6b6b;
        }

        body {
            background-color: var(--bg-primary);
            color: var(--text-primary);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            padding: 20px;
            margin: 0;
        }

        .form-container {
            background-color: var(--card-bg);
            border-radius: 12px;
            padding: 40px;
            border: 1px solid var(--border-color);
            width: 100%;
            max-width: 450px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            text-align: center;
        }

        .logo {
            margin-bottom: 30px;
        }

        .logo img {
            width: 60px;
            height: 60px;
            margin-bottom: 15px;
        }

        .form-title {
            font-size: 1.5rem;
            font-weight: 600;
            margin-bottom: 10px;
            color: var(--text-primary);
        }

        .form-description {
            color: var(--text-secondary);
            margin-bottom: 25px;
            line-height: 1.5;
        }

        .form-group {
            margin-bottom: 20px;
            text-align: left;
        }

        .form-control {
            width: 100%;
            padding: 12px 15px;
            border-radius: 8px;
            border: 1px solid var(--border-color);
            background-color: var(--bg-primary);
            color: var(--text-primary);
            font-size: 1rem;
            transition: border-color 0.2s ease;
        }

        .form-control:focus {
            outline: none;
            border-color: var(--accent-color);
        }

        .submit-btn {
            width: 100%;
            padding: 12px;
            background-color: var(--accent-color);
            color: white;
            border: none;
            border-radius: 8px;
            font-weight: 600;
            font-size: 1rem;
            cursor: pointer;
            transition: background-color 0.2s ease;
        }

        .submit-btn:hover {
            background-color: #4f46e5;
        }

        .error-message {
            background-color: rgba(255, 107, 107, 0.1);
            color: var(--error-color);
            padding: 12px;
            border-radius: 8px;
            margin: 20px 0;
            border-left: 4px solid var(--error-color);
            font-size: 0.9rem;
        }

        .back-link {
            display: inline-block;
            margin-top: 20px;
            color: var(--accent-color);
            text-decoration: none;
            font-weight: 500;
        }

        .back-link:hover {
            text-decoration: underline;
        }

        @media (max-width: 576px) {
            .form-container {
                padding: 30px 20px;
            }
        }
    </style>
</head>
<body>
    <div class="form-container">
        <div class="logo">
            <img src="/uploads/output.png" alt="Pocket Wallet Logo">
            <h2 class="form-title">Reset Your Password</h2>
        </div>
        
        <p class="form-description">Enter your email address to receive a verification code for password reset.</p>
        
        <?php if (!empty($message)): ?>
            <div class="error-message"><?= htmlspecialchars($message) ?></div>
        <?php endif; ?>

        <form action="forgot_password.php" method="POST">
            <div class="form-group">
                <input type="email" name="email" class="form-control" placeholder="Enter your email address" required>
            </div>
            
            <button type="submit" class="submit-btn">
                Send Verification Code <i class="fas fa-paper-plane" style="margin-left: 5px;"></i>
            </button>
            
            <a href="login.php" class="back-link">
                <i class="fas fa-arrow-left" style="margin-right: 5px;"></i> Back to Login
            </a>
        </form>
    </div>
</body>
</html>