<?php
// Database connection
include($_SERVER['DOCUMENT_ROOT'] . '/config.php');


try {
    // Create a new PDO connection
    $conn = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validate and sanitize input
    $id = filter_input(INPUT_POST, 'id', FILTER_VALIDATE_INT);
    $status = filter_input(INPUT_POST, 'status', FILTER_SANITIZE_STRING);

    // Ensure inputs are valid
    if ($id && in_array($status, ['pending', 'completed', 'cancelled'])) {
        try {
            // Fetch the current record to ensure it exists
            $stmt = $conn->prepare("SELECT * FROM deposits WHERE id = :id");
            $stmt->bindParam(':id', $id);
            $stmt->execute();
            $deposit = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$deposit) {
                // Redirect back with an error if the deposit record is not found
                header("Location: coin-deposit-request.php?message=Invalid deposit request");
                exit();
            }

            // Update the status in the database
            $stmt = $conn->prepare("UPDATE deposits SET status = :status WHERE id = :id");
            $stmt->bindParam(':status', $status);
            $stmt->bindParam(':id', $id);

            if ($stmt->execute()) {
                // Redirect back to the deposit requests page with a success message
                header("Location: coin-deposit-request.php?message=Status updated successfully");
                exit();
            } else {
                // Redirect back with an error message
                header("Location: coin-deposit-request.php?message=Failed to update status");
                exit();
            }
        } catch (PDOException $e) {
            die("Failed to update status: " . $e->getMessage());
        }
    } else {
        // Redirect back with an error message
        header("Location: coin-deposit-request.php?message=Invalid input");
        exit();
    }
} else {
    // Redirect back if accessed directly
    header("Location: coin-deposit-request.php");
    exit();
}
?>
