<?php
session_start();
header('Content-Type: application/json');

require_once($_SERVER['DOCUMENT_ROOT'] . '/config.php');

// Get input data
$input = json_decode(file_get_contents('php://input'), true) ?: $_POST;
$orderId = $input['order_id'] ?? null;
$newStatus = $input['status'] ?? null;
$notes = $input['notes'] ?? '';

// Validate input
if (!$orderId || !$newStatus) {
    echo json_encode(['success' => false, 'message' => 'Missing required parameters']);
    exit();
}

try {
    $conn->beginTransaction();
    
    // 1. Get the order details
    $orderQuery = "SELECT * FROM crypto_orders WHERE order_id = ?";
    $orderStmt = $conn->prepare($orderQuery);
    $orderStmt->execute([$orderId]);
    $order = $orderStmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$order) {
        throw new Exception("Order not found");
    }
    
    // 2. Update the order status
    $updateQuery = "UPDATE crypto_orders SET status = ?, admin_notes = ?, processed_at = NOW() WHERE order_id = ?";
    $updateStmt = $conn->prepare($updateQuery);
    $updateStmt->execute([$newStatus, $notes, $orderId]);
    
    // 3. If status is changing to completed, process the transaction
    if ($newStatus == 'completed' && $order['status'] != 'completed') {
        $coinColumn = '';
        switch ($order['coin_name']) {
            case 'bitcoin': $coinColumn = 'btc_balance'; break;
            case 'ethereum': $coinColumn = 'eth_balance'; break;
            case 'tether': $coinColumn = 'usdt_balance'; break;
            case 'usd-coin': $coinColumn = 'usdc_balance'; break;
            default: throw new Exception("Invalid coin type");
        }
        
        if ($order['order_type'] == 'buy') {
            // Add crypto to user's balance
            $updateUser = "UPDATE users SET $coinColumn = $coinColumn + ? WHERE id = ?";
            $conn->prepare($updateUser)->execute([$order['amount'], $order['user_id']]);
        } else {
            // For sell orders, we already deducted USD, now we need to add back USD and deduct crypto
            $updateUser = "UPDATE users SET 
                           balance = balance + ?,
                           $coinColumn = $coinColumn - ? 
                           WHERE id = ?";
            $conn->prepare($updateUser)->execute([
                $order['total_price'], 
                $order['amount'], 
                $order['user_id']
            ]);
        }
    }
    
    $conn->commit();
    echo json_encode(['success' => true, 'message' => 'Order status updated successfully']);
} catch (Exception $e) {
    $conn->rollBack();
    echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
}
?>