<?php
session_start();
include($_SERVER['DOCUMENT_ROOT'] . '/config.php');

// Verify admin is logged in
if (!isset($_SESSION['admin_id']) || empty($_SESSION['admin_id'])) {
    header('Location: admin_login.php');
    exit();
}

// Enable error logging but disable display
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', dirname(__DIR__) . '/logs/error.log');

try {
    // Fetch all users for the dropdown
    $usersQuery = $conn->prepare("SELECT id, username FROM users");
    $usersQuery->execute();
    $users = $usersQuery->fetchAll(PDO::FETCH_ASSOC);

    // Handle form submission
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $userId = $_POST['user_id'];
        $action = $_POST['action'];
        $amount = $_POST['amount'];
        $balanceType = $_POST['balance_type'];

        if ($userId && $action && $amount && $balanceType) {
            if ($action === 'credit') {
                $query = "UPDATE users SET $balanceType = $balanceType + :amount WHERE id = :id";
            } elseif ($action === 'debit') {
                $query = "UPDATE users SET $balanceType = $balanceType - :amount WHERE id = :id";
            } elseif ($action === 'edit') {
                $query = "UPDATE users SET $balanceType = :amount WHERE id = :id";
            }

            $stmt = $conn->prepare($query);
            $stmt->bindParam(':amount', $amount, PDO::PARAM_STR);
            $stmt->bindParam(':id', $userId, PDO::PARAM_INT);

            if ($stmt->execute()) {
                $message = "Balance updated successfully!";
            } else {
                $message = "Failed to update balance.";
            }
        } else {
            $message = "Please fill in all fields.";
        }
    }

    // Fetch all users with balances for the table
    $allUsersQuery = $conn->prepare("SELECT id, username, btc_balance, eth_balance, usdt_balance, usdc_balance, profit_balance, balance FROM users");
    $allUsersQuery->execute();
    $allUsers = $allUsersQuery->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    error_log($e->getMessage());
    $message = "An error occurred. Please check the error log.";
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
        }

        :root {
            --sidebar-bg: #14213d;
            --sidebar-text: #a8b2d1;
            --sidebar-hover: #1a2c5b;
            --active-link: #2a4494;
            --primary-text: #333;
            --secondary-text: #777;
            --card-bg: #fff;
            --main-bg: #f0f2f5;
            --deposit-color: #3498db;
            --withdraw-color: #e74c3c;
            --button-color: #0d6efd;
            --hover-color: #0b5ed7;
        }

        body {
            display: flex;
            background-color: var(--main-bg);
            min-height: 100vh;
        }

        /* Mobile nav toggle */
        .mobile-nav-toggle {
            display: none;
            position: fixed;
            top: 15px;
            left: 15px;
            z-index: 1050;
            background-color: var(--sidebar-bg);
            color: var(--sidebar-text);
            width: 40px;
            height: 40px;
            border-radius: 4px;
            justify-content: center;
            align-items: center;
            cursor: pointer;
            border: none;
            font-size: 20px;
        }

        /* Overlay for mobile */
        .overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 900;
        }

        /* Sidebar Styles */
        .sidebar {
            width: 250px;
            background-color: var(--sidebar-bg);
            color: var(--sidebar-text);
            height: 100vh;
            position: fixed;
            transition: all 0.3s ease;
            overflow-y: auto;
            z-index: 1000;
        }

        .sidebar-header {
            padding: 20px;
            font-size: 18px;
            font-weight: bold;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .sidebar-menu {
            margin-top: 20px;
        }

        .section-title {
            padding: 10px 20px;
            font-size: 12px;
            text-transform: uppercase;
            letter-spacing: 1px;
            color: #8a94a7;
            margin-top: 10px;
        }

        .menu-item {
            display: flex;
            align-items: center;
            padding: 12px 20px;
            text-decoration: none;
            color: var(--sidebar-text);
            transition: all 0.3s ease;
        }

        .menu-item:hover {
            background-color: var(--sidebar-hover);
        }

        .menu-item.active {
            background-color: var(--active-link);
            color: white;
        }

        .menu-item i {
            margin-right: 10px;
            width: 20px;
            text-align: center;
        }

        /* Main Content */
        .main-content {
            flex: 1;
            margin-left: 250px;
            padding: 20px;
            width: calc(100% - 250px);
            transition: all 0.3s ease;
        }

        .top-bar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 1px solid #eee;
        }

        .page-icon {
            font-size: 20px;
            color: var(--primary-text);
        }

        .user-info {
            display: flex;
            align-items: center;
        }

        .user-icon {
            width: 32px;
            height: 32px;
            background-color: var(--button-color);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            margin-right: 10px;
        }

        .user-role {
            display: flex;
            flex-direction: column;
        }

        .role-name {
            font-size: 12px;
            color: var(--secondary-text);
        }

        /* Overview Section */
        .overview-section {
            margin-bottom: 30px;
        }

        .overview-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }

        .overview-title {
            font-size: 24px;
            font-weight: 500;
            color: var(--primary-text);
        }

        .overview-description {
            font-size: 14px;
            color: var(--secondary-text);
            margin-top: 5px;
        }

        .view-users-btn {
            padding: 8px 16px;
            background-color: var(--button-color);
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            display: flex;
            align-items: center;
            transition: background-color 0.3s;
        }

        .view-users-btn:hover {
            background-color: var(--hover-color);
        }

        .view-users-btn i {
            margin-right: 6px;
        }

        /* Cards Grid */
        .cards-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
            margin-bottom: 20px;
        }

        .card {
            background-color: var(--card-bg);
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            padding: 20px;
            position: relative;
        }

        .card-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
        }

        .card-title {
            font-size: 16px;
            color: var(--primary-text);
        }

        .card-icon {
            font-size: 14px;
            color: var(--secondary-text);
            cursor: pointer;
        }

        .card-amount {
            font-size: 28px;
            font-weight: 600;
            margin-bottom: 20px;
        }

        .deposit-bar {
            height: 4px;
            width: 100%;
            background-color: var(--deposit-color);
            border-radius: 2px;
        }

        .withdraw-bar {
            height: 4px;
            width: 100%;
            background-color: var(--withdraw-color);
            border-radius: 2px;
        }

        /* Stats Card */
        .stats-card {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 20px;
        }

        .stat-item {
            margin-bottom: 15px;
        }

        .stat-label {
            display: flex;
            align-items: center;
            margin-bottom: 5px;
            font-size: 14px;
            color: var(--secondary-text);
        }

        .stat-label-circle {
            width: 12px;
            height: 12px;
            border-radius: 50%;
            margin-right: 8px;
        }

        .deposit-circle {
            background-color: #f39c12;
        }

        .withdraw-circle {
            background-color: #e74c3c;
        }

        .transaction-circle {
            background-color: #9b59b6;
        }

        .users-circle {
            background-color: #3498db;
        }

        .stat-value {
            font-size: 24px;
            font-weight: 500;
        }

        /* Footer */
        .footer {
            font-size: 12px;
            color: var(--secondary-text);
            margin-top: 40px;
            padding-top: 10px;
            border-top: 1px solid #eee;
        }

        /* Responsive */
        @media (max-width: 992px) {
            .sidebar {
                width: 80px;
            }
            .sidebar-header {
                padding: 15px 10px;
                text-align: center;
                font-size: 14px;
            }
            .menu-item span, .section-title {
                display: none;
            }
            .menu-item {
                justify-content: center;
                padding: 15px 0;
            }
            .menu-item i {
                margin-right: 0;
                font-size: 18px;
            }
            .main-content {
                margin-left: 80px;
                width: calc(100% - 80px);
            }
        }

        @media (max-width: 768px) {
            .cards-grid {
                grid-template-columns: 1fr;
            }
            .stats-card {
                grid-template-columns: 1fr;
            }
            .mobile-nav-toggle {
                display: flex;
            }
            .sidebar {
                transform: translateX(-100%);
                width: 250px;
            }
            .sidebar.active {
                transform: translateX(0);
            }
            .menu-item span, .section-title {
                display: block;
            }
            .menu-item {
                justify-content: flex-start;
                padding: 12px 20px;
            }
            .menu-item i {
                margin-right: 10px;
            }
            .main-content {
                margin-left: 0;
                width: 100%;
                padding-top: 60px;
            }
            .overlay.active {
                display: block;
            }
        }

        @media (max-width: 576px) {
            .overview-header {
                flex-direction: column;
                align-items: flex-start;
            }
            .view-users-btn {
                margin-top: 10px;
            }
        }
    </style>
</head>
<body>
    <!-- Mobile menu toggle -->
    <button class="mobile-nav-toggle" id="navToggle">
        <i class="fas fa-bars"></i>
    </button>

               <!-- Overlay for closing the sidebar on mobile -->
    <div class="overlay" id="overlay"></div>

    <!-- Sidebar -->
    <div class="sidebar" id="sidebar">
        <div class="sidebar-header">ADMIN DASHBOARD</div>
        <div class="sidebar-menu">
            <a href="/admin/admin_dashboard.php" class="menu-item active">
                <i class="fas fa-th-large"></i>
                <span>Dashboard</span>
            </a>
            <a href="/admin/coin-deposit-request.php" class="menu-item">
                <i class="fas fa-arrow-circle-down"></i>
                <span>Deposit Coin</span>
            </a>
             <a href="/admin/deposit_requests.php" class="menu-item">
                <i class="fas fa-money-check-alt"></i>
                <span>Deposit Check</span>
            </a>
            <a href="/admin/transfer-request.php" class="menu-item">
                <i class="fas fa-arrow-circle-up"></i>
                <span>Withdraw</span>
            </a>
            <a href="/admin/manage-payment-method.php" class="menu-item">
                <i class="fas fa-exchange-alt"></i>
                <span>Manage Payment Method</span>
            </a>
            <a href="/admin/admin_staking.php" class="menu-item">
                <i class="fas fa-lock"></i>
                <span>Manage Staking</span>
            </a>
            <a href="/admin/admin_staking_transactions.php" class="menu-item">
                <i class="fas fa-lock"></i>
                <span>Manage Staking Transations</span>
            </a>
            <a href="/admin/admin_stocks.php" class="menu-item">
                <i class="fas fa-chart-bar"></i>
                <span>Manage Stocks</span>
            </a>
            <a href="/admin/admin_stock_transactions.php" class="menu-item">
                <i class="fas fa-chart-bar"></i>
                <span>Manage Stocks Transations</span>
            </a>
            <a href="/admin/admin_bots.php" class="menu-item">
                <i class="fas fa-robot"></i>
                <span>Manage Bot</span>
            </a>
            <a href="/admin/investment.php" class="menu-item">
                <i class="fas fa-coins"></i>
                <span>Manage Investment</span>
            </a>
            
            <a href="/admin/crypto_orders.php" class="menu-item">
                <i class="fas fa-coins"></i>
                <span>Manage Crypto Order</span>
            </a>
            
            <a href="/admin/update_balance.php" class="menu-item">
                <i class="fas fa-file-invoice-dollar"></i>
                <span>Update Balances</span>
            </a>
            <a href="/admin/kyc-request.php" class="menu-item">
                <i class="fas fa-id-card"></i>
                <span>KYC</span>
            </a>
            <a href="/admin/admin_send_notification.php" class="menu-item">
                <i class="fas fa-bell"></i>
                <span>Manage Notifications</span>
            </a>

            <div class="section-title">USER MANAGEMENT</div>
            <a href="/admin/manage_users.php" class="menu-item">
                <i class="fas fa-users"></i>
                <span>Manage Users</span>
            </a>
            <div class="section-title">Approve SignUp</div>
            <a href="/admin/admin_approval.php" class="menu-item">
                <i class="fas fa-user-check"></i>
                <span>Approve SignUp</span>
            </a>
            <div class="section-title">Change Password</div>
            <a href="/admin/change_password.php" class="menu-item">
                <i class="fas fa-unlock-alt"></i>
                <span>Change Password</span>
            </a>

            <div class="section-title">MANAGEMENT</div>
            <a href="/admin/logout.php" class="menu-item">
                <i class="fas fa-sign-out"></i>
                <span>Sign Out</span>
            </a>
        </div>
    </div>

    <!-- Main Content -->
    <div class="main-content" id="mainContent">
        <div class="top-bar">
            <div class="page-icon">
                <i class="fas fa-clipboard"></i>
            </div>
            <div class="user-info">
                <div class="user-icon">
                    <i class="fas fa-user"></i>
                </div>
                <div class="user-role">
                    <div>Admin</div>
                    <div class="role-name">Administrator <i class="fas fa-chevron-down"></i></div>
                </div>
            </div>
        </div>

        <!-- Overview Section -->
        <div class="overview-section">
            <div class="overview-header">
                <div>
                    <h2 class="overview-title">Overview</h2>
                    <p class="overview-description">Here is an insight of what's going on.</p>
                </div>
                <button class="view-users-btn">
                    <i class="fas fa-users"></i> View All Users
                </button>
            </div>

 <div class="container">
    <h1>Update Balance</h1>

    <?php if (isset($message)): ?>
        <p class="message"><?= htmlspecialchars($message) ?></p>
    <?php endif; ?>

    <form method="POST">
        <div class="form-group">
            <label for="user_search">Select User:</label>
            <div class="advanced-select">
                <div class="select-header">
                    <input type="text" id="user_search" placeholder="Search users..." autocomplete="off">
                    <span class="dropdown-arrow">▼</span>
                </div>
                <div class="select-options" id="search_results">
                    <?php foreach ($users as $user): ?>
                        <div class="option" data-value="<?= htmlspecialchars($user['id']) ?>">
                            <?= htmlspecialchars($user['username']) ?>
                        </div>
                    <?php endforeach; ?>
                </div>
                <select name="user_id" id="user_id" required style="display: none;">
                    <option value="">-- Select User --</option>
                    <?php foreach ($users as $user): ?>
                        <option value="<?= htmlspecialchars($user['id']) ?>"><?= htmlspecialchars($user['username']) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
        </div>

        <!-- Rest of your form remains the same -->
        <div class="form-group">
            <label for="balance_type">Balance Type:</label>
            <select name="balance_type" id="balance_type" required>
                <option value="">-- Select Balance Type --</option>
                <option value="balance">Balance</option>
                <option value="btc_balance">Btc Balance</option>
                <option value="eth_balance">Eth Balance</option>
                <option value="usdt_balance">Usdt Balance</option>
                <option value="usdc_balance">Usdc Balance</option>
                <option value="profit_balance">Profit Balance</option>
            </select>
        </div>

        <div class="form-group">
            <label for="action">Action:</label>
            <select name="action" id="action" required>
                <option value="">-- Select Action --</option>
                <option value="credit">Credit</option>
                <option value="debit">Debit</option>
                <option value="edit">Edit</option>
            </select>
        </div>

        <div class="form-group">
            <label for="amount">Amount:</label>
            <input type="number" name="amount" id="amount" step="0.01" required>
        </div>

        <button type="submit">Update</button>
    </form>


    <table>
        <thead>
            <tr>
                <th>Username</th>
                <th>Balance</th>
                <th>Btc Balance</th>
                <th>Eth Balance</th>
                <th>Usdt Balance</th>
                <th>Usdc Balance</th>
                <th>Profit Balance</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($allUsers as $user): ?>
                <tr>
                    <td><?= htmlspecialchars($user['username']) ?></td>
                    <td><?= number_format($user['balance'], 2) ?></td>
                    <td><?= number_format($user['btc_balance'], 2) ?></td>
                    <td><?= number_format($user['eth_balance'], 2) ?></td>
                    <td><?= number_format($user['usdt_balance'], 2) ?></td>
                    <td><?= number_format($user['usdc_balance'], 2) ?></td>
                    <td><?= number_format($user['profit_balance'], 2) ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    </div>
    <div class="user-cards">
    <?php foreach ($allUsers as $user): ?>
    <div class="user-card">
        <h3><?= htmlspecialchars($user['username']) ?></h3>
        <p><strong>Balance:</strong> <?= number_format($user['balance'], 2) ?></p>
        <p><strong>BTC Balance:</strong> <?= number_format($user['btc_balance'], 8) ?></p>
        <p><strong>ETH Balance:</strong> <?= number_format($user['eth_balance'], 8) ?></p>
        <p><strong>USDT Balance:</strong> <?= number_format($user['usdt_balance'], 2) ?></p>
        <p><strong>USDC Balance:</strong> <?= number_format($user['usdc_balance'], 2) ?></p>
        <p><strong>PROFIT Balance:</strong> <?= number_format($user['profit_balance'], 2) ?></p>
    </div>
    <?php endforeach; ?>
</div>
<style>
    .advanced-select {
        position: relative;
        width: 100%;
        font-family: Arial, sans-serif;
    }
    
    .select-header {
        display: flex;
        align-items: center;
        border: 1px solid #ddd;
        border-radius: 4px;
        background-color: #f9f9f9;
        transition: all 0.3s ease;
    }
    
    .select-header:hover {
        border-color: #bbb;
    }
    
    .select-header:focus-within {
        border-color: #4a90e2;
        box-shadow: 0 0 5px rgba(74, 144, 226, 0.3);
    }
    
    #user_search {
        flex: 1;
        padding: 10px 15px;
        border: none;
        outline: none;
        background: transparent;
        font-size: 16px;
    }
    
    .dropdown-arrow {
        padding: 0 15px;
        cursor: pointer;
        color: #666;
    }
    
    .select-options {
        position: absolute;
        top: 100%;
        left: 0;
        right: 0;
        max-height: 300px;
        overflow-y: auto;
        background: #fff;
        border: 1px solid #ddd;
        border-top: none;
        border-radius: 0 0 4px 4px;
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        z-index: 1000;
        display: none;
    }
    
    .option {
        padding: 10px 15px;
        cursor: pointer;
        transition: background-color 0.2s;
    }
    
    .option:hover {
        background-color: #f0f0f0;
    }
    
    .option.selected {
        background-color: #e0e0e0;
        font-weight: bold;
    }
    
    .no-results {
        padding: 10px 15px;
        color: #666;
        font-style: italic;
    }
    
    .select-options.active {
        display: block;
    }
</style>
    <style>
    
       /* Add this CSS to your existing styles */
.container {
    background-color: var(--card-bg);
    border-radius: 8px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
    padding: 20px;
    margin-bottom: 20px;
}

.container h1 {
    font-size: 24px;
    color: var(--primary-text);
    margin-bottom: 20px;
    padding-bottom: 10px;
    border-bottom: 1px solid #eee;
}

.message {
    padding: 10px;
    margin-bottom: 15px;
    border-radius: 4px;
    background-color: #e8f5e9;
    color: #2e7d32;
}

/* Form styling */
form {
    margin-bottom: 30px;
}

.form-group {
    margin-bottom: 15px;
}

label {
    display: block;
    margin-bottom: 5px;
    font-weight: 500;
    color: var(--primary-text);
}

select, input[type="number"] {
    width: 100%;
    padding: 10px;
    border: 1px solid #ddd;
    border-radius: 4px;
    font-family: inherit;
    background-color: white;
}

button[type="submit"] {
    padding: 10px 20px;
    background-color: var(--button-color);
    color: white;
    border: none;
    border-radius: 4px;
    cursor: pointer;
    font-size: 16px;
    transition: background-color 0.3s;
    margin-top: 10px;
}

button[type="submit"]:hover {
    background-color: var(--hover-color);
}

/* Table styling for desktop */
.table-wrapper {
    overflow-x: auto;
    margin-bottom: 20px;
    -webkit-overflow-scrolling: touch;
}

table {
    width: 100%;
    border-collapse: collapse;
    min-width: 800px;
}

table th, 
table td {
    padding: 12px 15px;
    text-align: left;
    border-bottom: 1px solid #eee;
}

table th {
    background-color: #f8f9fa;
    color: var(--primary-text);
    font-weight: 500;
    position: sticky;
    top: 0;
}

table tr:hover {
    background-color: #f8f9fa;
}

/* Mobile cards - hidden by default */
.user-cards {
    display: none;
    grid-template-columns: 1fr;
    gap: 15px;
}

.user-card {
    background-color: var(--card-bg);
    border-radius: 8px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
    padding: 15px;
    border: 1px solid #eee;
}

.user-card h3 {
    font-size: 18px;
    margin-bottom: 10px;
    color: var(--primary-text);
}

.user-card p {
    margin-bottom: 8px;
    font-size: 14px;
    color: var(--secondary-text);
}

.user-card strong {
    color: var(--primary-text);
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .table-wrapper {
        display: none;
    }
    .table  {
        display: none;
    }
    .user-cards {
        display: grid;
    }
    
    .form-group {
        margin-bottom: 12px;
    }
    
    select, input[type="number"] {
        padding: 8px 12px;
    }
}

@media (max-width: 576px) {
    .container {
        padding: 15px;
    }
    
    .user-card {
        padding: 12px;
    }
}
 .table-wrapper {
        display: none;
    }
    </style>
   <!-- Footer -->
        <div class="footer">
            Pocket © 2024. All rights reserved.
        </div>
    </div>

    <script>
        // Get references to elements
        const navToggle = document.getElementById('navToggle');
        const sidebar = document.getElementById('sidebar');
        const overlay = document.getElementById('overlay');
        const mainContent = document.getElementById('mainContent');

        // Toggle sidebar
        navToggle.addEventListener('click', function() {
            sidebar.classList.toggle('active');
            overlay.classList.toggle('active');
        });

        // Close sidebar when clicking on overlay
        overlay.addEventListener('click', function() {
            sidebar.classList.remove('active');
            overlay.classList.remove('active');
        });

        // Close sidebar when clicking on main content (for mobile)
        mainContent.addEventListener('click', function() {
            if (window.innerWidth <= 768 && sidebar.classList.contains('active')) {
                sidebar.classList.remove('active');
                overlay.classList.remove('active');
            }
        });

        // Handle window resize
        window.addEventListener('resize', function() {
            if (window.innerWidth > 768) {
                sidebar.classList.remove('active');
                overlay.classList.remove('active');
            }
        });

        // Close sidebar when clicking menu items (for mobile)
        const menuItems = document.querySelectorAll('.menu-item');
        menuItems.forEach(item => {
            item.addEventListener('click', function() {
                if (window.innerWidth <= 768) {
                    sidebar.classList.remove('active');
                    overlay.classList.remove('active');
                }
            });
        });
   document.addEventListener('DOMContentLoaded', function() {
    const userSearch = document.getElementById('user_search');
    const searchResults = document.getElementById('search_results');
    const userIdSelect = document.getElementById('user_id');
    const dropdownArrow = document.querySelector('.dropdown-arrow');
    const advancedSelect = document.querySelector('.advanced-select');
    let allOptions = Array.from(searchResults.querySelectorAll('.option'));
    
    // Toggle dropdown visibility
    dropdownArrow.addEventListener('click', function() {
        searchResults.classList.toggle('active');
        if (searchResults.classList.contains('active')) {
            userSearch.focus();
        }
    });
    
    // Filter options based on search input
    userSearch.addEventListener('input', function() {
        const searchTerm = this.value.toLowerCase();
        
        // Show all options if search is empty
        if (searchTerm === '') {
            allOptions.forEach(option => {
                option.style.display = 'block';
            });
            return;
        }
        
        // Filter options
        const filteredOptions = allOptions.filter(option => 
            option.textContent.toLowerCase().includes(searchTerm)
        );
        
        // Update display
        allOptions.forEach(option => {
            option.style.display = 'none';
        });
        
        filteredOptions.forEach(option => {
            option.style.display = 'block';
        });
        
        // Show dropdown if not already visible
        if (!searchResults.classList.contains('active')) {
            searchResults.classList.add('active');
        }
    });
    
    // Handle option selection
    searchResults.addEventListener('click', function(e) {
        if (e.target.classList.contains('option')) {
            const selectedValue = e.target.dataset.value;
            const selectedText = e.target.textContent;
            
            // Update UI
            userSearch.value = selectedText;
            
            // Remove previous selection
            allOptions.forEach(option => {
                option.classList.remove('selected');
            });
            
            // Mark new selection
            e.target.classList.add('selected');
            
            // Update hidden select
            userIdSelect.value = selectedValue;
            
            // Close dropdown
            searchResults.classList.remove('active');
        }
    });
    
    // Close dropdown when clicking outside
    document.addEventListener('click', function(e) {
        if (!advancedSelect.contains(e.target)) {
            searchResults.classList.remove('active');
        }
    });
    
    // Keyboard navigation
    userSearch.addEventListener('keydown', function(e) {
        if (e.key === 'ArrowDown' || e.key === 'ArrowUp' || e.key === 'Enter') {
            const visibleOptions = allOptions.filter(option => 
                option.style.display !== 'none'
            );
            
            if (visibleOptions.length === 0) return;
            
            let activeIndex = -1;
            visibleOptions.forEach((option, index) => {
                if (option.classList.contains('selected')) {
                    activeIndex = index;
                    option.classList.remove('selected');
                }
            });
            
            if (e.key === 'ArrowDown') {
                activeIndex = (activeIndex + 1) % visibleOptions.length;
            } else if (e.key === 'ArrowUp') {
                activeIndex = (activeIndex - 1 + visibleOptions.length) % visibleOptions.length;
            } else if (e.key === 'Enter' && activeIndex >= 0) {
                visibleOptions[activeIndex].click();
                return;
            }
            
            if (activeIndex >= 0) {
                visibleOptions[activeIndex].classList.add('selected');
                visibleOptions[activeIndex].scrollIntoView({ block: 'nearest' });
            }
            
            e.preventDefault();
        } else if (e.key === 'Escape') {
            searchResults.classList.remove('active');
        }
    });
});
    </script>
</body>
</html>