<?php
// Include the database configuration
include($_SERVER['DOCUMENT_ROOT'] . '/config.php');

// Enable error logging but disable display
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', dirname(__DIR__) . '/logs/error.log');

try {
    // Fetch all users for the dropdown
    $usersQuery = $conn->prepare("SELECT id, username FROM users");
    $usersQuery->execute();
    $users = $usersQuery->fetchAll(PDO::FETCH_ASSOC);

    // Fetch all transactions, including balance type
    $transactionsQuery = $conn->prepare("
        SELECT t.id, u.username, t.recipient_name, t.amount, t.status, t.date, t.balance_type
        FROM transactions t
        JOIN users u ON t.user_id = u.id
        ORDER BY t.date DESC
    ");
    $transactionsQuery->execute();
    $transactions = $transactionsQuery->fetchAll(PDO::FETCH_ASSOC);

    // Handle form submissions
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        if (isset($_POST['add_transaction'])) {
            $userId = $_POST['user_id'];
            $recipientName = $_POST['recipient_name'];
            $amount = $_POST['amount'];
            $status = $_POST['status'];
            $balanceType = $_POST['balance_type'];  // Capture balance type from form
            $date = $_POST['date'];

            // Add the transaction including balance type
            $addTransactionQuery = $conn->prepare(
                "INSERT INTO transactions (user_id, recipient_name, amount, status, balance_type, date) 
                 VALUES (:user_id, :recipient_name, :amount, :status, :balance_type, :date)"
            );
            $addTransactionQuery->execute([
                ':user_id' => $userId,
                ':recipient_name' => $recipientName,
                ':amount' => $amount,
                ':status' => $status,
                ':balance_type' => $balanceType,  // Include balance type in the query
                ':date' => $date,
            ]);
        } elseif (isset($_POST['update_transaction'])) {
            $transactionId = $_POST['transaction_id'];
            $recipientName = $_POST['recipient_name'];
            $amount = $_POST['amount'];
            $status = $_POST['status'];
            $balanceType = $_POST['balance_type'];  // Capture balance type from form
            $date = $_POST['date'];

            // Update the transaction including balance type
            $updateTransactionQuery = $conn->prepare(
                "UPDATE transactions SET recipient_name = :recipient_name, amount = :amount, 
                 status = :status, balance_type = :balance_type, date = :date WHERE id = :id"
            );
            $updateTransactionQuery->execute([
                ':recipient_name' => $recipientName,
                ':amount' => $amount,
                ':status' => $status,
                ':balance_type' => $balanceType,  // Include balance type in the update query
                ':date' => $date,
                ':id' => $transactionId,
            ]);
        } elseif (isset($_POST['delete_transaction'])) {
            $transactionId = $_POST['transaction_id'];
            $deleteTransactionQuery = $conn->prepare("DELETE FROM transactions WHERE id = :id");
            $deleteTransactionQuery->execute([':id' => $transactionId]);
        }
    }
} catch (Exception $e) {
    error_log($e->getMessage());
    $message = "An error occurred. Please check the error log.";
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
     <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin dashboard</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
     <style>
       * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Roboto', sans-serif;
        }

        body {
            display: flex;
            flex-direction: row;
            min-height: 100vh;
            background-color: #f7f7f7;
        }

        /* Sidebar */
        .sidebar {
            background-color: #c70000;
            color: #fff;
            width: 250px;
            padding: 20px;
            position: fixed;
            top: 0;
            bottom: 0;
            left: -250px;
            transition: transform 0.3s ease-in-out;
            display: flex;
            flex-direction: column;
            align-items: center;
            overflow-y: auto; /* Enable scrolling */
            height: 100%; /* Make sure sidebar fills the screen */
        }

        .sidebar.active {
            transform: translateX(250px);
        }

        .sidebar .profile {
            text-align: center;
            margin-bottom: 30px;
        }

        .sidebar .profile img {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            margin-bottom: 10px;
        }

        .sidebar .profile h3 {
            font-size: 18px;
            margin-bottom: 5px;
        }

        .sidebar .profile p {
            font-size: 14px;
            color: #ddd;
        }

        .sidebar ul {
            list-style: none;
            margin-top: auto;
            margin-bottom: auto;
            width: 100%;
        }

        .sidebar ul li {
            margin-bottom: 20px;
        }

        .sidebar ul li a {
            display: flex;
            align-items: center;
            gap: 15px;
            color: #fff;
            text-decoration: none;
            font-size: 16px;
            padding: 10px;
            border-radius: 5px;
            transition: background-color 0.3s;
        }

        .sidebar ul li a i {
            font-size: 20px;
        }

        .sidebar ul li a:hover {
            background-color: #a00000;
        }

        /* Navbar */
        .navbar {
            background-color: #c70000;
            color: #fff;
            padding: 10px 20px;
            width: 100%;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1000;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .navbar .menu-toggle {
            font-size: 24px;
            cursor: pointer;
        }

        .navbar .icons {
            display: flex;
            gap: 15px;
        }

        .navbar .icons i {
            font-size: 24px;
            cursor: pointer;
        }

       .container {
        padding: 20px;
        margin: 0 auto;
    }

   
    .container {
        padding: 20px;
        margin: 0 auto;
    }

    h1 {
        text-align: center;
        font-size: 2rem;
        color: #333;
        margin-bottom: 30px;
    }

    

    @media (max-width: 768px) {
        .account-card {
            flex: 1 1 100%; /* Stacks cards on mobile */
            max-width: 100%;
        }

        h1 {
            font-size: 1.5rem;
        }
    }

    /* Utility Styles */
    .currency div:first-child {
        font-weight: bold;
    }
    </style>
</head>
<body>
 <div class="sidebar" id="sidebar">
        <div class="profile">
            <img src="/assets/default-profile.png" alt="User Profile">
        </div>
        <ul>
            <li><a href="/admin/admin_dashboard.php"><i class="fas fa-tachometer-alt"></i>Dashboard</a></li>
            <li><a href="/admin/manage_users.php"><i class="fas fa-user"></i>Manage Users</a></li>
            <li><a href="/admin/bsb.php"><i class="fas fa-list"></i>Bsb & Account Number</a></li>
            <li><a href="/admin/transfer-request.php"><i class="fas fa-paper-plane"></i>Manage Transfers</a></li>
            <li><a href="/admin/update_bills.php"><i class="fas fa-list"></i>Update Bills</a></li>
             <li><a href="/admin/update_accountstatement.php"><i class="fas fa-money-check-alt"></i>Update Account Statements</a></li>
             <li><a href="/admin/manage_cards.php"><i class="fas fa-hand-holding-usd"></i>Manage Cards</a></li>
            <li><a href="/admin/transfer_date.php"><i class="fas fa-paper-plane"></i>Update Transactions Date</a></li>
            <li><a href="/admin/deposit_requests.php"><i class="fas fa-money-check-alt"></i>Manage Deposits</a></li>
            <li><a href="/admin/update_balance.php"><i class="fas fa-file-invoice-dollar"></i>Update Balances</a></li>
            <li><a href="/admin/kyc-request.php"><i class="fas fa-id-card"></i>Manage KYC</a></li>
            <li><a href="/admin/admin_loans.php"><i class="fas fa-hand-holding-usd"></i>Manage Loan Credit</a></li>
            <li><a href="/admin/admin_send_notification.php"><i class="fas fa-bell"></i>Manage Notifications</a></li>
           <li><a href="/admin/logout.php"><i class="fas fa-sign-out"></i>Sign Out</a></li>
            <li><a href="#"><i class=""></i></a></li>
        </ul>
    </div>

    <div class="navbar">
        <i class="fas fa-bars menu-toggle" id="menuToggle"></i>
        <span>Admin Dashboard</span>
        <div class="icons">
            <i class="fas fa-bell"></i>
            <i class="fas fa-user-circle"></i>
        </div>
    </div>
    <div class="container">
    <h1></h1>
    
   <div class="container">
        <h1>User Account Summary</h1>

       <!-- Add Transaction Form -->
<form method="POST">
    <h2>Add Transaction</h2>
    <div class="form-group">
        <label for="user_id">Select User:</label>
        <select name="user_id" required>
            <option value="">-- Select User --</option>
            <?php foreach ($users as $user): ?>
                <option value="<?= htmlspecialchars($user['id']) ?>"><?= htmlspecialchars($user['username']) ?></option>
            <?php endforeach; ?>
        </select>
    </div>
    <div class="form-group">
        <label for="recipient_name">Recipient Name:</label>
        <input type="text" name="recipient_name" required>
    </div>
    <div class="form-group">
        <label for="amount">Amount:</label>
        <input type="number" name="amount" step="0.01" required>
    </div>
    <div class="form-group">
        <label for="status">Status:</label>
        <select name="status" required>
            <option value="Debit">Debit</option>
            <option value="Credit">Credit</option>
            <option value="Failed">Failed</option>
        </select>
    </div>
    <div class="form-group">
        <label for="balance_type">Balance Type:</label>
        <select name="balance_type" required>
            <option value="">-- Select Balance Type --</option>
            <option value="Savings">Savings</option>
            <option value="Current">Current</option>
            <option value="Premier">Premier</option>
        </select>
    </div>
    <div class="form-group">
        <label for="date">Date:</label>
        <input type="date" name="date" required>
    </div>
    <button type="submit" name="add_transaction">Add Transaction</button>
</form>

        <!-- Transaction History Table -->
        <h2>Transaction History</h2>
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>User</th>
                    <th>Recipient</th>
                    <th>Amount</th>
                    <th>Status</th>
                    <th>Balance Type</th>
                    <th>Date</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($transactions as $transaction): ?>
                    <tr>
                        <td><?= htmlspecialchars($transaction['id']) ?></td>
                        <td><?= htmlspecialchars($transaction['username']) ?></td>
                        <td><?= htmlspecialchars($transaction['recipient_name']) ?></td>
                        <td><?= number_format($transaction['amount'], 2) ?></td>
                        <td><?= htmlspecialchars($transaction['status']) ?></td>
                        <td><?= htmlspecialchars($transaction['balance_type']) ?></td>
                        <td><?= htmlspecialchars($transaction['date']) ?></td>
                        <td>
                            <form method="POST" style="display:inline;">
                                <input type="hidden" name="transaction_id" value="<?= htmlspecialchars($transaction['id']) ?>">
                                <button type="submit" name="delete_transaction" onclick="return confirm('Are you sure?')">Delete</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

<!-- Mobile Responsive Styles -->
 <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f9f9f9;
        }
        .container {
            max-width: 1200px;
            margin: auto;
            padding: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 12px;
            text-align: left;
        }
        th {
            background-color: #c70000;
            color: white;
        }
        .form-group {
            margin-bottom: 15px;
        }
        label {
            display: block;
            margin-bottom: 5px;
        }
        input, select, button {
            width: 100%;
            padding: 10px;
            margin: 5px 0;
            border: 1px solid #ddd;
            border-radius: 4px;
        }
        button {
            background-color: #c70000;
            color: white;
            cursor: pointer;
        }
        button:hover {
            background-color: #c70000;
        }
        @media (max-width: 768px) {
            table {
                font-size: 14px;
            }
            th, td {
                padding: 8px;
            }
        }
    </style>

    
    <script>
        const menuToggle = document.getElementById('menuToggle');
        const sidebar = document.getElementById('sidebar');
        const content = document.getElementById('content');

        menuToggle.addEventListener('click', () => {
            sidebar.classList.toggle('active');
            content.classList.toggle('shrink');
        });
    </script>
</body>
</html>
