<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    die(json_encode(['success' => false, 'message' => 'Unauthorized']));
}

include($_SERVER['DOCUMENT_ROOT'] . '/config.php');

$orderIds = $_POST['order_ids'];
$action = $_POST['action'];
$notes = $_POST['notes'];

// Map action to status
$statusMap = [
    'complete' => 'completed',
    'reject' => 'rejected',
    'pending' => 'pending'
];
$newStatus = $statusMap[$action] ?? 'pending';

try {
    $conn->beginTransaction();
    
    // Update all orders
    $placeholders = implode(',', array_fill(0, count($orderIds), '?'));
    $updateQuery = "UPDATE crypto_orders SET status = ?, admin_notes = ? 
                    WHERE order_id IN ($placeholders)";
    $params = array_merge([$newStatus, $notes], $orderIds);
    $conn->prepare($updateQuery)->execute($params);
    
    // If completing orders, process the transactions
    if ($newStatus == 'completed') {
        // Get all orders that were pending
        $ordersQuery = "SELECT * FROM crypto_orders 
                         WHERE order_id IN ($placeholders) AND status = 'pending'";
        $ordersStmt = $conn->prepare($ordersQuery);
        $ordersStmt->execute($orderIds);
        $orders = $ordersStmt->fetchAll(PDO::FETCH_ASSOC);
        
        foreach ($orders as $order) {
            $coinColumn = '';
            switch ($order['coin_name']) {
                case 'bitcoin': $coinColumn = 'btc_balance'; break;
                case 'ethereum': $coinColumn = 'eth_balance'; break;
                case 'tether': $coinColumn = 'usdt_balance'; break;
                case 'usd-coin': $coinColumn = 'usdc_balance'; break;
            }
            
            if ($order['order_type'] == 'buy') {
                // Add crypto to user's balance
                $updateUser = "UPDATE users SET $coinColumn = $coinColumn + ? WHERE id = ?";
                $conn->prepare($updateUser)->execute([$order['amount'], $order['user_id']]);
            } else {
                // For sell orders, add back USD and deduct crypto
                $updateUser = "UPDATE users SET 
                               balance = balance + ?,
                               $coinColumn = $coinColumn - ? 
                               WHERE id = ?";
                $conn->prepare($updateUser)->execute([$order['total_price'], $order['amount'], $order['user_id']]);
            }
        }
    }
    
    $conn->commit();
    echo json_encode(['success' => true, 'message' => count($orderIds) . ' orders updated successfully']);
} catch (Exception $e) {
    $conn->rollBack();
    echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
}
?>