<?php
// Include necessary files for database connection and session management
include($_SERVER['DOCUMENT_ROOT'] . '/config.php');
session_start();

// Check if admin is logged in
if (!isset($_SESSION['admin_id'])) {
    header("Location: login.php"); // Redirect to login page if not an admin
    exit;
}

// Fetch all users from the users table
$query = "SELECT id, username, account_number, bsb_number FROM users";
$stmt = $conn->prepare($query);
$stmt->execute();
$users = $stmt->fetchAll();

// Handle form submission to update account number or BSB number
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['edit_account'])) {
        $user_id = $_POST['user_id'];
        $new_account_number = $_POST['new_account_number'];
        
        // Update account number
        $update_query = "UPDATE users SET account_number = :account_number WHERE id = :user_id";
        $update_stmt = $conn->prepare($update_query);
        $update_stmt->execute(['account_number' => $new_account_number, 'user_id' => $user_id]);
    }

    if (isset($_POST['edit_bsb'])) {
        $user_id = $_POST['user_id'];
        $new_bsb_number = $_POST['new_bsb_number'];

        // Update BSB number
        $update_bsb_query = "UPDATE users SET bsb_number = :bsb_number WHERE id = :user_id";
        $update_bsb_stmt = $conn->prepare($update_bsb_query);
        $update_bsb_stmt->execute(['bsb_number' => $new_bsb_number, 'user_id' => $user_id]);
    }

    // Redirect to the same page after updating
    header("Location: bsb.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
     <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin dashboard</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
     <style>
       * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Roboto', sans-serif;
        }

        body {
            display: flex;
            flex-direction: row;
            min-height: 100vh;
            background-color: #f7f7f7;
        }

        /* Sidebar */
        .sidebar {
            background-color: #c70000;
            color: #fff;
            width: 250px;
            padding: 20px;
            position: fixed;
            top: 0;
            bottom: 0;
            left: -250px;
            transition: transform 0.3s ease-in-out;
            display: flex;
            flex-direction: column;
            align-items: center;
            overflow-y: auto; /* Enable scrolling */
            height: 100%; /* Make sure sidebar fills the screen */
        }

        .sidebar.active {
            transform: translateX(250px);
        }

        .sidebar .profile {
            text-align: center;
            margin-bottom: 30px;
        }

        .sidebar .profile img {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            margin-bottom: 10px;
        }

        .sidebar .profile h3 {
            font-size: 18px;
            margin-bottom: 5px;
        }

        .sidebar .profile p {
            font-size: 14px;
            color: #ddd;
        }

        .sidebar ul {
            list-style: none;
            margin-top: auto;
            margin-bottom: auto;
            width: 100%;
        }

        .sidebar ul li {
            margin-bottom: 20px;
        }

        .sidebar ul li a {
            display: flex;
            align-items: center;
            gap: 15px;
            color: #fff;
            text-decoration: none;
            font-size: 16px;
            padding: 10px;
            border-radius: 5px;
            transition: background-color 0.3s;
        }

        .sidebar ul li a i {
            font-size: 20px;
        }

        .sidebar ul li a:hover {
            background-color: #a00000;
        }

        /* Navbar */
        .navbar {
            background-color: #c70000;
            color: #fff;
            padding: 10px 20px;
            width: 100%;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1000;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .navbar .menu-toggle {
            font-size: 24px;
            cursor: pointer;
        }

        .navbar .icons {
            display: flex;
            gap: 15px;
        }

        .navbar .icons i {
            font-size: 24px;
            cursor: pointer;
        }

       .container {
        padding: 20px;
        margin: 0 auto;
    }

   
    .container {
        padding: 20px;
        margin: 0 auto;
    }

    h1 {
        text-align: center;
        font-size: 2rem;
        color: #333;
        margin-bottom: 30px;
    }

    /* Flexbox Content Styling */
    .content {
        display: flex;
        flex-wrap: wrap; /* Allows wrapping on smaller screens */
        justify-content: center;
        gap: 80px; /* Space between cards */
        margin: 80px auto;
        padding: 80px;
    }

    /* Card Styles */
    .account-card {
        background-color: #ffffff;
        border-radius: 10px;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        padding: 20px;
        flex: 1 1 calc(33.33% - 40px); /* Responsive 3-column layout */
        max-width: 300px; /* Limits the card width */
        text-align: center;
        transition: transform 0.3s ease;
        margin: 10px; /* Adds extra space between cards */
    }

    .account-card:hover {
        transform: scale(1.05); /* Slight zoom effect on hover */
    }

    .account-card h2 {
        color: #c70000;
        font-size: 1.5rem;
        margin-bottom: 15px;
    }

    .account-card .currency {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-top: 10px;
    }

    .account-card .currency div {
        font-size: 1.2rem;
        color: #666;
    }

    /* Responsive Design */
    @media (max-width: 1024px) {
        .content {
            flex-wrap: wrap;
            margin-left: 0;
            padding: 10px;
        }

        .account-card {
            flex: 1 1 calc(50% - 40px); /* 2-column layout on tablets */
        }
    }

    @media (max-width: 768px) {
        .account-card {
            flex: 1 1 100%; /* Stacks cards on mobile */
            max-width: 100%;
        }

        h1 {
            font-size: 1.5rem;
        }
    }

    /* Utility Styles */
    .currency div:first-child {
        font-weight: bold;
    }
    </style>
   <style>
    /* General Styles */
    body {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        background-color: #f4f4f9;
        margin: 0;
        padding: 0;
    }

    .container {
        width: 90%;
        margin: 20px auto;
        background-color: #fff;
        padding: 30px;
        border-radius: 8px;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    }

    h1 {
        text-align: center;
        color: #333;
        margin-bottom: 20px;
        font-size: 24px;
    }

    /* Desktop Table */
    .table-wrapper {
        display: block;
        overflow-x: auto;
        margin-bottom: 30px;
    }

    .user-table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 20px;
    }

    .user-table th, .user-table td {
        padding: 12px;
        text-align: left;
        border: 1px solid #ddd;
    }

    .user-table th {
        background-color: #007bff;
        color: #fff;
    }

    .user-table tr:nth-child(even) {
        background-color: #f9f9f9;
    }

    .action-btn {
        padding: 8px 12px;
        font-size: 14px;
        border: none;
        border-radius: 5px;
        cursor: pointer;
        transition: background-color 0.3s ease;
    }

    .delete-btn {
        background-color: #e74c3c;
        color: white;
    }

    .delete-btn:hover {
        background-color: #c0392b;
    }

    /* Card Layout for Mobile */
    .user-cards {
        display: none;
        margin-top: 20px;
    }

    .user-card {
        background-color: #fff;
        padding: 20px;
        margin-bottom: 20px;
        border-radius: 8px;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    }

    .user-card h3 {
        margin-top: 0;
        color: #007bff;
    }

    .user-card p {
        margin: 10px 0;
        color: #333;
    }

    .user-card form {
        margin-top: 10px;
    }

    /* Responsive Design */
    @media (max-width: 768px) {
        .user-table {
            display: none;
        }

        .user-cards {
            display: block;
        }
    }

    @media (max-width: 480px) {
        .user-table th, .user-table td {
            font-size: 12px;
            padding: 8px;
        }

        .user-card p {
            font-size: 14px;
        }

        .action-btn {
            padding: 6px 10px;
            font-size: 12px;
        }
    }
</style>
</head>
<body>
   <div class="sidebar" id="sidebar">
        <div class="profile">
            <img src="/assets/default-profile.png" alt="User Profile">
        </div>
        <ul>
            <li><a href="/admin/admin_dashboard.php"><i class="fas fa-tachometer-alt"></i>Dashboard</a></li>
            <li><a href="/admin/manage_users.php"><i class="fas fa-user"></i>Manage Users</a></li>
            <li><a href="/admin/bsb.php"><i class="fas fa-list"></i>Bsb & Account Number</a></li>
            <li><a href="/admin/transfer-request.php"><i class="fas fa-paper-plane"></i>Manage Transfers</a></li>
            <li><a href="/admin/update_bills.php"><i class="fas fa-list"></i>Update Bills</a></li>
             <li><a href="/admin/update_accountstatement.php"><i class="fas fa-money-check-alt"></i>Update Account Statements</a></li>
             <li><a href="/admin/manage_cards.php"><i class="fas fa-hand-holding-usd"></i>Manage Cards</a></li>
            <li><a href="/admin/transfer_date.php"><i class="fas fa-paper-plane"></i>Update Transactions Date</a></li>
            <li><a href="/admin/deposit_requests.php"><i class="fas fa-money-check-alt"></i>Manage Deposits</a></li>
            <li><a href="/admin/update_balance.php"><i class="fas fa-file-invoice-dollar"></i>Update Balances</a></li>
            <li><a href="/admin/kyc-request.php"><i class="fas fa-id-card"></i>Manage KYC</a></li>
            <li><a href="/admin/admin_loans.php"><i class="fas fa-hand-holding-usd"></i>Manage Loan Credit</a></li>
            <li><a href="/admin/admin_send_notification.php"><i class="fas fa-bell"></i>Manage Notifications</a></li>
           <li><a href="/admin/logout.php"><i class="fas fa-sign-out"></i>Sign Out</a></li>
            <li><a href="#"><i class=""></i></a></li>
        </ul>
    </div>

    <div class="navbar">
        <i class="fas fa-bars menu-toggle" id="menuToggle"></i>
        <span>Admin Dashboard</span>
        <div class="icons">
            <i class="fas fa-bell"></i>
            <i class="fas fa-user-circle"></i>
        </div>
    </div>
   <div class="container">
    <h1>Edit User Accounts</h1>

    <div class="table-wrapper">
        <table class="user-table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Username</th>
                    <th>Account Number</th>
                    <th>BSB Number</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($users as $user): ?>
                <tr>
                    <td><?php echo htmlspecialchars($user['id']); ?></td>
                    <td><?php echo htmlspecialchars($user['username']); ?></td>
                    <td>
                        <?php echo htmlspecialchars($user['account_number']); ?>
                        <form action="" method="POST">
                            <input type="hidden" name="user_id" value="<?php echo $user['id']; ?>">
                            <input type="text" name="new_account_number" placeholder="New Account Number" required>
                            <button type="submit" name="edit_account">Edit Account Number</button>
                        </form>
                    </td>
                    <td>
                        <?php echo htmlspecialchars($user['bsb_number']); ?>
                        <form action="" method="POST">
                            <input type="hidden" name="user_id" value="<?php echo $user['id']; ?>">
                            <input type="text" name="new_bsb_number" placeholder="New BSB Number" required>
                            <button type="submit" name="edit_bsb">Edit BSB Number</button>
                        </form>
                    </td>
                    <td>
                        <form action="" method="POST">
                            <input type="hidden" name="user_id" value="<?php echo $user['id']; ?>">
                            <input type="text" name="new_bsb_number" placeholder="Create BSB Number" required>
                            <button type="submit" name="edit_bsb">Create BSB</button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <div class="user-cards">
        <?php foreach ($users as $user): ?>
        <div class="user-card">
            <h3>User ID: <?php echo $user['id']; ?></h3>
            <p><strong>Username:</strong> <?php echo htmlspecialchars($user['username']); ?></p>
            <p><strong>Account Number:</strong> <?php echo htmlspecialchars($user['account_number']); ?></p>
            <form action="" method="POST">
                <input type="hidden" name="user_id" value="<?php echo $user['id']; ?>">
                <input type="text" name="new_account_number" placeholder="New Account Number" required>
                <button type="submit" name="edit_account">Edit Account Number</button>
            </form>
            <p><strong>BSB Number:</strong> <?php echo htmlspecialchars($user['bsb_number']); ?></p>
            <form action="" method="POST">
                <input type="hidden" name="user_id" value="<?php echo $user['id']; ?>">
                <input type="text" name="new_bsb_number" placeholder="New BSB Number" required>
                <button type="submit" name="edit_bsb">Edit BSB Number</button>
            </form>
            <form action="" method="POST">
                <input type="hidden" name="user_id" value="<?php echo $user['id']; ?>">
                <input type="text" name="new_bsb_number" placeholder="Create BSB Number" required>
                <button type="submit" name="edit_bsb">Create BSB</button>
            </form>
        </div>
        <?php endforeach; ?>
    </div>
</div>
    <script>
        const menuToggle = document.getElementById('menuToggle');
        const sidebar = document.getElementById('sidebar');
        const content = document.getElementById('content');

        menuToggle.addEventListener('click', () => {
            sidebar.classList.toggle('active');
            content.classList.toggle('shrink');
        });
    </script>
</body>
</html>
