<?php
session_start();
include($_SERVER['DOCUMENT_ROOT'] . '/config.php'); // Update with your correct config path

// Ensure the admin is logged in
if (!isset($_SESSION['admin_id'])) {
    header('Location: admin_login.php');
    exit();
}

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Handle status updates
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['loan_id'], $_POST['status'])) {
    $stmt = $conn->prepare("UPDATE loan_requests SET status = ? WHERE id = ?");
    $stmt->execute([$_POST['status'], $_POST['loan_id']]);
    
    header('Location: admin_loans.php');
    exit;
}

// Fetch all loan requests
$stmt = $conn->prepare("
    SELECT l.*, u.username 
    FROM loan_requests l 
    JOIN users u ON l.user_id = u.id 
    ORDER BY l.created_at DESC
");
$stmt->execute();
$loans = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
     <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin dashboard</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
     <style>
       * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Roboto', sans-serif;
        }

        body {
            display: flex;
            flex-direction: row;
            min-height: 100vh;
            background-color: #f7f7f7;
        }

        /* Sidebar */
        .sidebar {
            background-color: #c70000;
            color: #fff;
            width: 250px;
            padding: 20px;
            position: fixed;
            top: 0;
            bottom: 0;
            left: -250px;
            transition: transform 0.3s ease-in-out;
            display: flex;
            flex-direction: column;
            align-items: center;
            overflow-y: auto; /* Enable scrolling */
            height: 100%; /* Make sure sidebar fills the screen */
        }

        .sidebar.active {
            transform: translateX(250px);
        }

        .sidebar .profile {
            text-align: center;
            margin-bottom: 30px;
        }

        .sidebar .profile img {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            margin-bottom: 10px;
        }

        .sidebar .profile h3 {
            font-size: 18px;
            margin-bottom: 5px;
        }

        .sidebar .profile p {
            font-size: 14px;
            color: #ddd;
        }

        .sidebar ul {
            list-style: none;
            margin-top: auto;
            margin-bottom: auto;
            width: 100%;
        }

        .sidebar ul li {
            margin-bottom: 20px;
        }

        .sidebar ul li a {
            display: flex;
            align-items: center;
            gap: 15px;
            color: #fff;
            text-decoration: none;
            font-size: 16px;
            padding: 10px;
            border-radius: 5px;
            transition: background-color 0.3s;
        }

        .sidebar ul li a i {
            font-size: 20px;
        }

        .sidebar ul li a:hover {
            background-color: #a00000;
        }

        /* Navbar */
        .navbar {
            background-color: #c70000;
            color: #fff;
            padding: 10px 20px;
            width: 100%;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1000;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .navbar .menu-toggle {
            font-size: 24px;
            cursor: pointer;
        }

        .navbar .icons {
            display: flex;
            gap: 15px;
        }

        .navbar .icons i {
            font-size: 24px;
            cursor: pointer;
        }

       .container {
        padding: 20px;
        margin: 0 auto;
    }

   
    .container {
        padding: 20px;
        margin: 0 auto;
    }

    h1 {
        text-align: center;
        font-size: 2rem;
        color: #333;
        margin-bottom: 30px;
    }

    

    @media (max-width: 768px) {
        .account-card {
            flex: 1 1 100%; /* Stacks cards on mobile */
            max-width: 100%;
        }

        h1 {
            font-size: 1.5rem;
        }
    }

    /* Utility Styles */
    .currency div:first-child {
        font-weight: bold;
    }
    </style>
</head>
<body>
<div class="sidebar" id="sidebar">
        <div class="profile">
            <img src="/assets/default-profile.png" alt="User Profile">
        </div>
        <ul>
            <li><a href="/admin/admin_dashboard.php"><i class="fas fa-tachometer-alt"></i>Dashboard</a></li>
            <li><a href="/admin/manage_users.php"><i class="fas fa-user"></i>Manage Users</a></li>
            <li><a href="/admin/bsb.php"><i class="fas fa-list"></i>Bsb & Account Number</a></li>
            <li><a href="/admin/transfer-request.php"><i class="fas fa-paper-plane"></i>Manage Transfers</a></li>
            <li><a href="/admin/update_bills.php"><i class="fas fa-list"></i>Update Bills</a></li>
             <li><a href="/admin/update_accountstatement.php"><i class="fas fa-money-check-alt"></i>Update Account Statements</a></li>
             <li><a href="/admin/manage_cards.php"><i class="fas fa-hand-holding-usd"></i>Manage Cards</a></li>
            <li><a href="/admin/transfer_date.php"><i class="fas fa-paper-plane"></i>Update Transactions Date</a></li>
            <li><a href="/admin/deposit_requests.php"><i class="fas fa-money-check-alt"></i>Manage Deposits</a></li>
            <li><a href="/admin/update_balance.php"><i class="fas fa-file-invoice-dollar"></i>Update Balances</a></li>
            <li><a href="/admin/kyc-request.php"><i class="fas fa-id-card"></i>Manage KYC</a></li>
            <li><a href="/admin/admin_loans.php"><i class="fas fa-hand-holding-usd"></i>Manage Loan Credit</a></li>
            <li><a href="/admin/admin_send_notification.php"><i class="fas fa-bell"></i>Manage Notifications</a></li>
           <li><a href="/admin/logout.php"><i class="fas fa-sign-out"></i>Sign Out</a></li>
            <li><a href="#"><i class=""></i></a></li>
        </ul>
    </div>


    <div class="navbar">
        <i class="fas fa-bars menu-toggle" id="menuToggle"></i>
        <span>Admin Dashboard</span>
        <div class="icons">
            <i class="fas fa-bell"></i>
            <i class="fas fa-user-circle"></i>
        </div>
    </div>
    <div class="container">
    <h1></h1>
    
    <div class="container">
    <h1>Loan Administration</h1>

    <div class="loan-cards">
        <?php foreach ($loans as $loan): ?>
        <div class="loan-card">
            <h3>Loan ID: <?php echo $loan['id']; ?></h3>
            <p><strong>Username:</strong> <?php echo htmlspecialchars($loan['username']); ?></p>
            <p><strong>Loan Amount:</strong> USD <?php echo number_format($loan['loan_amount'], 2); ?></p>
            <p><strong>Credit Facility:</strong> <?php echo htmlspecialchars($loan['credit_facility']); ?></p>
            <p><strong>Repayment Tenure:</strong> <?php echo htmlspecialchars($loan['repayment_tenure']); ?></p>
            <p><strong>Purpose:</strong> <?php echo htmlspecialchars($loan['purpose']); ?></p>
            <p><strong>Status:</strong>
                <span class="status-<?php echo $loan['status']; ?>">
                    <?php echo ucfirst($loan['status']); ?>
                </span>
            </p>
            <p><strong>Submitted On:</strong> <?php echo date('M j, Y', strtotime($loan['created_at'])); ?></p>

            <form method="POST" class="status-form">
                <input type="hidden" name="loan_id" value="<?php echo $loan['id']; ?>">
                <select name="status" required>
                    <option value="pending" <?php echo $loan['status'] === 'pending' ? 'selected' : ''; ?>>Pending</option>
                    <option value="approved" <?php echo $loan['status'] === 'approved' ? 'selected' : ''; ?>>Approved</option>
                    <option value="rejected" <?php echo $loan['status'] === 'rejected' ? 'selected' : ''; ?>>Rejected</option>
                </select>
                <button type="submit" class="btn-update">Update</button>
            </form>
        </div>
        <?php endforeach; ?>
    </div>
</div>

<!-- Mobile Responsive Styles -->
<style>
    .loan-cards {
        display: flex;
        flex-direction: column;
        gap: 20px;
    }

    .loan-card {
        background-color: #fff;
        padding: 20px;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        border-radius: 8px;
        display: flex;
        flex-direction: column;
        gap: 10px;
    }

    .loan-card h3 {
        font-size: 1.2em;
        margin-bottom: 10px;
    }

    .loan-card p {
        font-size: 1em;
        margin: 5px 0;
    }

    .status-form select {
        padding: 5px;
        font-size: 1em;
        border-radius: 8px;
        border: 1px solid #ddd;
        margin-right: 10px;
    }

    .btn-update {
        padding: 8px 15px;
        background-color: #c70000;
        color: white;
        border: none;
        border-radius: 8px;
        cursor: pointer;
        transition: background-color 0.3s;
    }

    .btn-update:hover {
        background-color: #c70000;
    }

    .loan-card .status-pending {
        color: orange;
    }

    .loan-card .status-approved {
        color: green;
    }

    .loan-card .status-rejected {
        color: red;
    }

    /* Mobile Responsiveness */
    @media (max-width: 768px) {
        .loan-card {
            padding: 15px;
        }

        .loan-card h3 {
            font-size: 1.1em;
        }

        .loan-card p {
            font-size: 0.9em;
        }

        .status-form select {
            font-size: 0.9em;
        }

        .btn-update {
            font-size: 0.9em;
            padding: 7px 12px;
        }

        h1 {
            font-size: 1.8em;
            text-align: center;
        }
    }
</style>

    
    <script>
        const menuToggle = document.getElementById('menuToggle');
        const sidebar = document.getElementById('sidebar');
        const content = document.getElementById('content');

        menuToggle.addEventListener('click', () => {
            sidebar.classList.toggle('active');
            content.classList.toggle('shrink');
        });
    </script>
</body>
</html>
